% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specification_table.R
\name{specification_table}
\alias{specification_table}
\alias{stable}
\title{Table of elements from a \code{StudySpecification}}
\usage{
specification_table(
  specification,
  x,
  y = NULL,
  sort = FALSE,
  decreasing = TRUE,
  use_var_names = FALSE,
  ...
)

stable(
  specification,
  x,
  y = NULL,
  sort = FALSE,
  decreasing = TRUE,
  use_var_names = FALSE,
  ...
)
}
\arguments{
\item{specification}{A \code{StudySpecification} object}

\item{x}{One of "treatment", "unit of assignment", (synonym "uoa"), "block".
Abbreviations are accepted. "unit of assignment" can be replaced by
"unitid" or "cluster" if the \code{StudySpecification} was created with
that element.}

\item{y}{Optionally, another string similar to \code{x}. A 1-dimensional
table is produced if \code{y} is left at its default, \code{NULL}.}

\item{sort}{Ignored if \code{y} is not \code{NULL}. If \code{FALSE}
(default), one-way table is sorted according to "names" of levels. If set
to \code{TRUE}, one-way table is sorted according to values.}

\item{decreasing}{If \code{sort} is \code{TRUE}, choose whether to sort
descending (\code{TRUE}, default) or ascending (\code{FALSE}).}

\item{use_var_names}{If \code{TRUE}, name dimensions of table returned by
variable names. If \code{FALSE} (default), name by their function (e.g.
"treatment" or "blocks"). Passing the \code{dnn} argument in \code{...}
(an argument of \code{\link[=table]{table()}}) overrides whatever is requested here.}

\item{...}{additional arguments \code{\link[=table]{table()}}}
}
\value{
A table of the requested variables.
}
\description{
Produces a table (1-dimensional, or 2-dimensional if \code{y}
is specified) of the elements of the \code{StudySpecification}.
}
\examples{
data(simdata)
spec <- obs_spec(z ~ unit_of_assignment(uoa1, uoa2) + block(bid),
                  data = simdata)
specification_table(spec, "treatment")
specification_table(spec, "treatment", "block", sort = TRUE, use_var_names = TRUE)
}
