% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biproportional-upper.R
\name{upper_apportionment}
\alias{upper_apportionment}
\title{Upper apportionment}
\usage{
upper_apportionment(
  votes_matrix,
  district_seats,
  weight_votes = TRUE,
  method = "round"
)
}
\arguments{
\item{votes_matrix}{Vote count matrix with votes by party in rows and votes by district
in columns.}

\item{district_seats}{Vector defining the number of seats per district. Must be the same
length as \code{ncol(votes_matrix)}. Values are name-matched to \code{votes_matrix} columns if both
are named. If the number of seats per district should be calculated according to the number
of votes (not the general use case), a single number for the total number of seats can be
used.}

\item{weight_votes}{By default (\code{TRUE}) it is assumed that each voter in a district has
as many votes as there are seats in a district. Thus, votes are weighted according to
the number of available district seats with \code{\link[=weight_votes_matrix]{weight_votes_matrix()}}. Set to \code{FALSE} if
the argument \code{votes_matrix} shows the number of \emph{voters} (e.g. because they can only cast
one vote for one party).}

\item{method}{Apportion method that defines how seats are assigned, see \code{\link[=proporz]{proporz()}}. Default
is the Sainte-Laguë/Webster method.}
}
\value{
A named list with \code{district} seats (for \code{votes_matrix} columns) and \code{party} seats
(for rows).
}
\description{
In the first step of biproportional apportionment parties are given seats according to the
sum of their votes across all districts.
}
\note{
The results from the upper apportionment define the number of seats for each party and
the number of seats for each district for the whole voting area. The lower apportionment
will only determine where (i.e. which district) the party seats are allocated. Thus, after
the upper apportionment is done, the final strength of a party/district within the
parliament is definite.
}
\examples{
votes_matrix = matrix(c(123,912,312,45,714,255,815,414,215), nrow = 3)
district_seats = c(7,5,8)

upper_apportionment(votes_matrix, district_seats)

}
\seealso{
\code{\link[=biproporz]{biproporz()}}, \code{\link[=lower_apportionment]{lower_apportionment()}}
}
