% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AC.R
\name{hmm_ac}
\alias{hmm_ac}
\title{hmm_ac}
\usage{
hmm_ac(hmm, lg = 4)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{lg}{The lag value, which indicates the distance between residues.}
}
\value{
A vector of length 20 \eqn{\times} the lag value; by default this is a vector of length 80.
}
\description{
This feature calculates the covariance between two residues separated by a lag value within
the same amino acid emission frequency column along the protein sequence.
}
\note{
The lag value must be less than the length of the protein sequence
}
\examples{
h<- hmm_ac(system.file("extdata", "1DLHA2-7", package="protHMM"))
}
\references{
Dong, Q., Zhou, S., & Guan, J. (2009).
A new taxonomy-based protein fold recognition approach based on autocross-covariance transformation.
Bioinformatics, 25(20), 2655–2662.
}
