% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bigrams.R
\name{hmm_bigrams}
\alias{hmm_bigrams}
\title{hmm_bigrams}
\usage{
hmm_bigrams(hmm)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}
}
\value{
A vector of length 400
}
\description{
This feature is calculated with a 20 x 20 matrix \eqn{B}, in which \eqn{B[i, j] = \sum_{a = 1}^{L-1} H_{a, i}H_{a+1, j}}.
\eqn{H} corresponds to the original HMM matrix, and \eqn{L} is the number of rows in \eqn{H}. Matrix \eqn{B} is then flattened to
a feature vector of length 400, and returned.
}
\examples{
h<- hmm_bigrams(system.file("extdata", "1DLHA2-7", package="protHMM"))
}
\references{
Lyons, J., Dehzangi, A., Heffernan, R., Yang, Y., Zhou, Y., Sharma, A., & Paliwal, K. K. (2015).
Advancing the Accuracy of Protein Fold Recognition by Utilizing Profiles From Hidden Markov Models.
IEEE Transactions on Nanobioscience, 14(7), 761–772.
}
