/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.ui.BrowseButton;
import com.qarks.util.files.diff.ui.BrowseListener;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DiffInputDialog
extends JDialog
implements ActionListener,
BrowseListener {
    private JButton ok;
    private JButton cancel;
    private JTextField leftFile;
    private JTextField rightFile;
    private boolean cancelled = false;
    private String defaultPath = System.getProperty("user.home");
    private BrowseButton leftBrowse;
    private BrowseButton rightBrowse;

    public DiffInputDialog(Window window, String string, String string2) {
        super(window, ResourceManager.getString((Object)ResourceKeyDiff.DIFF_INPUT), Dialog.ModalityType.APPLICATION_MODAL);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        jPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.LEFT_FILE)), 0);
        jPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.RIGHT_FILE)), 1);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 10, 10));
        this.leftFile = new JTextField(32);
        this.rightFile = new JTextField(32);
        jPanel2.add((Component)this.leftFile, 0);
        jPanel2.add((Component)this.rightFile, 1);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 10, 10));
        this.leftBrowse = new BrowseButton(this.leftFile, this.defaultPath, this);
        this.rightBrowse = new BrowseButton(this.rightFile, this.defaultPath, this);
        jPanel3.add((Component)this.leftBrowse, 0);
        jPanel3.add((Component)this.rightBrowse, 1);
        this.loadPath();
        if (string != null) {
            this.leftFile.setText(string);
        }
        if (string2 != null) {
            this.rightFile.setText(string2);
        }
        this.leftFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DiffInputDialog.this.checkInput();
            }
        });
        this.rightFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DiffInputDialog.this.checkInput();
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.add((Component)jPanel, "West");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "East");
        JPanel jPanel5 = new JPanel(new FlowLayout(2, 5, 5));
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.checkInput();
        jPanel5.add(this.ok);
        jPanel5.add(this.cancel);
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "South");
        jPanel6.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(jPanel6);
        this.pack();
    }

    @Override
    public void onBrowsed(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.defaultPath = file.getParentFile().getAbsolutePath();
            this.leftBrowse.setCurrentPath(this.defaultPath);
            this.rightBrowse.setCurrentPath(this.defaultPath);
        }
        this.checkInput();
    }

    private void checkInput() {
        this.ok.setEnabled(this.getLeftFilePath().length() > 0 && this.getRightFilePath().length() > 0);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getLeftFilePath() {
        return this.leftFile.getText();
    }

    public String getRightFilePath() {
        return this.rightFile.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPath() {
        String string = System.getProperty("user.home") + File.separator + ".sourcemanager";
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                File file2 = new File(file, "diff.properties");
                if (file2.exists()) {
                    fileInputStream = new FileInputStream(file2);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    this.leftFile.setText(properties.getProperty("left", ""));
                    this.rightFile.setText(properties.getProperty("right", ""));
                    this.defaultPath = properties.getProperty("defaultPath", System.getProperty("user.home"));
                    this.leftBrowse.setCurrentPath(this.defaultPath);
                    this.rightBrowse.setCurrentPath(this.defaultPath);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePath() {
        String string = System.getProperty("user.home") + File.separator + ".sourcemanager";
        Properties properties = new Properties();
        properties.put("left", this.getLeftFilePath());
        properties.put("right", this.getRightFilePath());
        properties.put("defaultPath", this.defaultPath);
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("could not create folder " + string);
            }
            File file2 = new File(file, "diff.properties");
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.OK)};
            if (!new File(this.getLeftFilePath()).exists()) {
                JOptionPane.showOptionDialog(this, ResourceManager.getString((Object)ResourceKeyDiff.FILE_NOT_FOUND, this.getLeftFilePath()), ResourceManager.getString((Object)ResourceKeyDiff.OPEN_FILE), -1, 0, null, objectArray, objectArray[0]);
                return;
            }
            if (!new File(this.getRightFilePath()).exists()) {
                JOptionPane.showOptionDialog(this, ResourceManager.getString((Object)ResourceKeyDiff.FILE_NOT_FOUND, this.getRightFilePath()), ResourceManager.getString((Object)ResourceKeyDiff.OPEN_FILE), -1, 0, null, objectArray, objectArray[0]);
                return;
            }
            this.savePath();
            this.dispose();
        } else {
            this.cancelled = true;
            this.dispose();
        }
    }
}

