% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdsw.R
\docType{class}
\name{Cdsw-class}
\alias{Cdsw-class}
\alias{Cdsw}
\title{Compute dynamic swath windows}
\arguments{
\item{list}{of masses}

\item{nbins}{number of bins default 25}

\item{maxwindow}{largest window size}

\item{minwindow}{smallest window size}

\item{digits}{mass precision default 2}

\item{digigits}{mass precision}

\item{max}{number of bins}

\item{plot}{default TRUE}

\item{overlap}{size of window overlap default 1 m/z}
}
\value{
array of masses

array with masses

array with masses

data.frame with columns:
- from (window start)
- to (window end)
- mid (window centre), width (window width)
- counts expected number of precursors

list with optimization scores

data.frame with optimized windows
}
\description{
initialize

create equidistant breaks

quantile breaks

sampling breaks

barplot showing the number of precursors per window

Table with window boundaries and statistics

summary of the binning process (see objectiveMS1Function for more details)

moves window start and end to region with as few as possible precursor masses

shows the generated DIA cycle
}
\section{Fields}{

\describe{
\item{\code{masses}}{MS1 masses}

\item{\code{breaks}}{the breaks}

\item{\code{nbins}}{number of bins}

\item{\code{digits}}{mass accuracy in result}
}}

\section{Methods}{

\describe{
\item{\code{asTable(overlap = 1)}}{make windows}

\item{\code{error()}}{show error}

\item{\code{optimizeWindows(digits = 1, maxbin = 15, plot = FALSE, overlap = 0)}}{optimizes the windows}

\item{\code{quantile_breaks(digits = 2)}}{same number of MS1 in each window but might violate hard constraints}

\item{\code{sampling_breaks(maxwindow = 150, minwindow = 5, digits = 2, plot = FALSE)}}{starts with quantile breaks but mixes with uniform data to satisfy had constraints}
}}

\examples{
data(masses)
cdsw <- Cdsw(masses)
tmp <- cdsw$sampling_breaks(maxwindow=100,plot=TRUE)
cdsw$plot()
cdsw$asTable()
cdsw$breaks
cdsw$optimizeWindows()
cdsw$showCycle()
}
