% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhoods.R
\name{calc_likes}
\alias{calc_likes}
\title{Calculate likelihoods for three three-state model structures}
\usage{
calc_likes(ptdata, dpam, cuttime = 0)
}
\arguments{
\item{ptdata}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item \code{ptid}: patient identifier
\item \code{pfs.durn}: duration of PFS from baseline
\item \code{pfs.flag}: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item \code{os.durn}: duration of OS from baseline
\item \code{os.flag}: event flag for OS (=1 if death occurred, 0 for censoring)
\item \code{ttp.durn}: duration of TTP from baseline (usually should be equal to pfs.durn)
\item \code{ttp.flag}: event flag for TTP (=1 if progression occurred, 0 for censoring).
}

Survival data for all other endpoints (time to progression, pre-progression death, post-progression survival) are derived from PFS and OS.}

\item{dpam}{List of survival regressions for each endpoint:
\itemize{
\item pre-progression death (PPD)
\item time to progression (TTP)
\item progression-free survival (PFS)
\item overall survival (OS)
\item post-progression survival clock forward (PPS-CF) and
\item post-progression survival clock reset (PPS-CR).
}}

\item{cuttime}{Time cutoff - this is nonzero for two-piece models.}
}
\value{
A list of three tibbles:
\code{all} is a tibble of results for all patients:
\itemize{
\item \code{methname}: the model structure or method.
\item \code{npar}: is the number of parameters used by that method.
\item \code{npts_1} to \code{npts_4} are the number of patients experiencing outcomes 1-4 respectively (see below), and \code{npts_tot} the total.
\item \code{ll_1} to \code{ll_4} are the log-likelihood values for patients experiencing outcomes 1-4 respectively (see below), and \code{ll_tot} the total.
\code{valid} is a tibble of the same design as \code{all} but only in patients with valid likelihoods for all 4 methods
\code{sum} is a tibble in respect of patients with valid likelihoods for all 4 methods providing:
\item \code{npts}: number of patients contributing results for this method.
\item \code{npar}: number of parameters used by that method.
\item \code{ll}: total log-likelihood
\item \code{AIC}: Akaike Information Criterion value for this model
\item \code{BIC}: Bayesian Information Criterion value for this model
}

The four outcomes are as follows:
\itemize{
\item (1) refers to patients who remain alive and progression-free during the follow-up;
\item (2) refers to patients who die without prior progression during the follow-up;
\item (3) refers to patients who progress and then remain alive for the remaining follow-up, and
\item (4) refers to patients who progress and die within the follow-up.
}
}
\description{
Calculate likelihood values and other summary output for the following three state models structures: partitioned survival, clock forward state transition, and clock reset state transition. The function requires appropriately formatted patient-level data, a set of fitted survival regressions, and the time cut-off (if two-piece modeling is used).
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
  )
calc_likes(bosonc, dpam=params)
}
}
