% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{data}
\name{PCIT}
\alias{PCIT}
\title{Data set on \emph{Personal and Corporate Income Tax}}
\format{
A time series data set of class '\code{data.frame}', 
  where the column \code{id_t} indicates the quarter of the year.
}
\source{
The prepared data set is directly obtainable from \emph{openICPSR}: 
  \doi{10.3886/E116190V1}. Supplementary Research Data. 
  This is open data under the \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0 license}.
}
\usage{
data("PCIT")
}
\description{
The data set \code{PCIT} consists of quarterly observations for
  \itemize{
  \item the average personal income tax rates \eqn{APITR}, 
  \item the average corporate income tax rates \eqn{ACITR}, 
  \item the logarithm of the personal income tax base \eqn{PITB}, 
  \item the logarithm of the corporate income tax base \eqn{CITB}, 
  \item the logarithm of government spending \eqn{GOV}, 
  \item the logarithm of GDP divided by population \eqn{RGDP}, and 
  \item the logarithm of government debt held by the public 
  divided by the GDP deflator and population \eqn{DEBT}.
  }
  Moreover, the proxies for shocks to personal \eqn{m\_PI} and corporate \eqn{m\_CI} 
  income taxes are prepended, where non-zero observations from the related 
  narratively identified shock series \eqn{T\_PI} resp. \eqn{T\_CI} have been demeaned. 
  The data set covers the period Q1 1950 to Q4 2006 \eqn{(T=228)} for the US.
}
\references{
Mertens, K., and Ravn, M. O. (2013):
  "The Dynamic Effects of Personal and Corporate Income Tax Changes in the 
  United States", \emph{American Economic Review}, 103, pp. 1212-1247.

Jentsch, C., and Lunsford, K. G. (2019):
  "The Dynamic Effects of Personal and Corporate Income Tax Changes in the 
  United States: Comment", \emph{American Economic Review}, 109, pp. 2655-2678.

Mertens, K., and Ravn, M. O. (2019):
  "The Dynamic Effects of Personal and Corporate Income Tax Changes in the 
  United States: Reply", \emph{American Economic Review}, 109, pp. 2679-2691.
}
\seealso{
Other data sets: 
\code{\link{ERPT}},
\code{\link{EURO}},
\code{\link{EU_w}},
\code{\link{ICAP}},
\code{\link{MDEM}},
\code{\link{MERM}},
\code{\link{PCAP}}
}
\concept{data sets}
\keyword{datasets}
