% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbin_barplot.R, R/table_plot.R
\name{qbin_barplot}
\alias{qbin_barplot}
\alias{table_plot}
\title{Quantile binned bar plot}
\usage{
qbin_barplot(
  data,
  x = NULL,
  n = 100,
  min_bin_size = NULL,
  overlap = NULL,
  ncols = NULL,
  fill = "#2f4f4f",
  type = c("median", "mean"),
  ...
)

table_plot(data, x = NULL, n = 100, ncols = ncol(data), fill = "#555555", ...)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{ncols}{The number of column to be used in the layout.}

\item{fill}{The color to use for the bars.}

\item{type}{The type of statistic to use for the bars.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A \code{list} of ggplot objects.
}
\description{
\code{\link[=qbin_barplot]{qbin_barplot()}} shows the median or mean for each quantile bin, thereby focusing on
the expected value per \code{\link[=qbin]{qbin()}}.
For a conditional plot, see \code{\link[=cond_barplot]{cond_barplot()}}.
}
\details{
The \code{table_plot} is a specific form of \code{qbin_barplot}
with \code{ncols} set to \code{ncol(data)}.
}
\examples{
\donttest{
  data("diamonds", package="ggplot2")

  table_plot(diamonds[c(1:4, 7)], "carat")

  qbin_barplot(iris, "Sepal.Length", n = 12)

  table_plot(iris, "Sepal.Length", n=12)
  table_plot(
    iris,
    x = "Sepal.Length",
    min_bin_size=20,
    overlap=TRUE
  )

  if (require(palmerpenguins)) {
    table_plot(penguins[1:7], "body_mass_g", 19)
  }
}
}
\seealso{
Other qbin plotting functions: 
\code{\link{qbin_boxplot}()},
\code{\link{qbin_heatmap}()},
\code{\link{qbin_lineplot}()}
}
\concept{qbin plotting functions}
