% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbin_boxplot.R
\name{qbin_boxplot}
\alias{qbin_boxplot}
\title{Quantile binned boxplot}
\usage{
qbin_boxplot(
  data,
  x = NULL,
  n = 100,
  min_bin_size = NULL,
  ncols = NULL,
  overlap = NULL,
  connect = FALSE,
  color = "#002f2f",
  fill = "#2f4f4f",
  auto_fill = FALSE,
  qmarker = NULL,
  xmarker = NULL,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{ncols}{The number of column to be used in the layout}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{connect}{if \code{TRUE} subsequent boxplots are connected}

\item{color}{The color to use for the lines}

\item{fill}{The color to use for the bars}

\item{auto_fill}{If \code{TRUE}, use a different color for each category}

\item{qmarker}{\code{numeric}, the quantile marker to use.}

\item{xmarker}{\code{numeric} the x marker, i.e. the value for x that is translated into a q value.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A \code{list} of ggplot objects.
}
\description{
\code{qbin_boxplot} creates quantile binned boxplots from \code{data} using \code{x} as the binning
variable. It focuses on the change of median between qbins. It is a
complement to \code{\link[=qbin_heatmap]{qbin_heatmap()}} which focuses on the distribution within the qbins.
}
\details{
The data is binned by the \code{x} and a boxplot is created for each bin.
The median of the subsequent boxplots are connected to highlight jumps in the
data. It hints at the dependecy of the variable on the binning variable.
}
\examples{
qbin_boxplot(
  iris,
  x = "Sepal.Length",
)

\donttest{
  qbin_boxplot(
    iris,
    x = "Sepal.Length",
    connect = TRUE,
    overlap = TRUE
  )

  qbin_boxplot(
    iris,
    x = "Sepal.Length",
    connect = TRUE,
    xmarker = 5.5,
    auto_fill = TRUE
  )

  data("diamonds", package="ggplot2")

  qbin_boxplot(
    diamonds[1:7],
    "carat",
    auto_fill = TRUE
  )

  qbin_boxplot(
    diamonds[1:7],
    "price",
    auto_fill = TRUE,
  )
}
}
\seealso{
Other qbin plotting functions: 
\code{\link{qbin_barplot}()},
\code{\link{qbin_heatmap}()},
\code{\link{qbin_lineplot}()}
}
\concept{qbin plotting functions}
