% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_checks.R
\name{density_plot}
\alias{density_plot}
\title{Density Plot for qbrms Models}
\usage{
density_plot(
  object,
  parameter = NULL,
  show_prior = FALSE,
  show_data = FALSE,
  ndraws = 100,
  prior_ndraws = 100,
  alpha_levels = list(posterior = 0.8, prior = 0.6, data = 1),
  colours = list(posterior = "#1F78B4", prior = "#E31A1C", data = "#000000"),
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{parameter}{Parameter name to plot. If \code{NULL}, plots the response distribution.}

\item{show_prior}{Logical; if \code{TRUE}, overlay the prior density.}

\item{show_data}{Logical; if \code{TRUE}, overlay the observed data density.}

\item{ndraws}{Number of posterior draws to use (default \code{100}).}

\item{prior_ndraws}{Number of prior draws to use (default \code{100}).}

\item{alpha_levels}{Named list controlling transparency for layers.}

\item{colours}{Named list of colours for layers.}

\item{seed}{Optional random seed.}

\item{verbose}{Logical; print progress messages.}
}
\value{
A \code{ggplot2} object.
}
\description{
Create density plots of posterior distributions with optional prior and
observed-data overlays. Returns a \code{ggplot2} object that can be modified
with standard ggplot2 syntax.
}
