% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqcs.R
\name{mstate.control}
\alias{mstate.control}
\title{Multivariate process state}
\usage{
mstate.control(x)
}
\arguments{
\item{x}{Object mqcd (Multivariate Quality Control Statistical)}

\item{control}{a logical value indicating whether the initial sample comes from a process under control.}
}
\description{
This function removes observations from the sample which violates 
the rules of a process under control
}
\examples{

##
##  Continuous data 
##
library(qcr)
set.seed(356)
x <- matrix(rnorm(66),ncol=3)
x <- rbind(x,matrix(rexp(66,100),ncol=3))
dim(x)
x <-mqcd(x)
str(x)
x <-mqcs.mewma(x)
str(x)
plot(x)
data.mqcs <- mstate.control(x)
x <-mqcs.mewma(data.mqcs)
plot(x)
}
