#' Seizure Counts for Epileptics
#'
#' The data set consists of seizure counts for 59 individuals with epilepsy. Counts
#' were recorded for four two-week periods (8 weeks total). Age is the only covariate.
#'
#' @format A \code{data.frame} with 236 rows and 9 variables (columns):
#' \describe{
#'   \item{y}{the count for the 2-week period.}
#'   \item{trt}{treatment, "placebo" or "progabide".}
#'   \item{base}{the counts in the baseline 8-week period.}
#'   \item{age}{subject's age, in years.}
#'   \item{V4}{0/1 indicator variable of period 4.}
#'   \item{subject}{subject number, 1 to 59.}
#'   \item{period}{period, 1 to 4.}
#'   \item{lbase}{log-counts for the baseline period, centred to have zero mean.}
#'   \item{lage}{log-ages, centred to have zero mean.}
#' }
#'
#' @source Thall, P. F. and Vail, S. C. (1990) Some covariance models for
#' longitudinal count data with over-dispersion. Biometrics 46, 657–671.
#'
#' @references Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics
#' with S. Fourth Edition. Springer.
#'
"epil"


#' MS data
#'
#'
#' @source Thal
#' @references Venab
#'
"exacerb"
