% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.r
\name{qiita_user}
\alias{qiita_user}
\alias{qiita_get_stockers}
\alias{qiita_get_users}
\alias{qiita_get_followees}
\alias{qiita_get_followers}
\alias{qiita_follow_user}
\alias{qiita_unfollow_user}
\alias{qiita_is_following_user}
\alias{qiita_get_authenticated_user}
\title{Qiita User API}
\usage{
qiita_get_stockers(item_id, per_page = 100L, page_offset = 0L, page_limit = 1L)

qiita_get_users(user_id)

qiita_get_followees(
  user_id,
  per_page = 100L,
  page_offset = 0L,
  page_limit = 1L
)

qiita_get_followers(
  user_id,
  per_page = 100L,
  page_offset = 0L,
  page_limit = 1L
)

qiita_follow_user(user_id)

qiita_unfollow_user(user_id)

qiita_is_following_user(user_id)

qiita_get_authenticated_user()
}
\arguments{
\item{item_id}{Item (article) ID.}

\item{per_page}{Number of items per one page.}

\item{page_offset}{Number of offset pages.}

\item{page_limit}{Max number of pages to retrieve.}

\item{user_id}{User ID (e.g. \code{"yutannihilation"}).}
}
\description{
Get, follow or unfollow users via Qiita API.
}
\examples{
\dontrun{
# get a user by id
qiita_get_users("yutannihilation")

# follow a user
qiita_follow_user("user1")

# unfollow a user
qiita_unfollow_user("user1")

# get the current user
qiita_get_authenticated_user()
}

}
