% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmj.R
\docType{package}
\name{qmj}
\alias{qmj-package}
\alias{qmj}
\title{Exploring a quality minus junk approach to evaluating stocks}
\description{
The \strong{qmj} package calculates quality scores for the companies 
in the Russell 3000 Index based on the paper 
\emph{Quality Minus Junk} by Clifford Asness, Andrea Frazzini, 
and Lasse Pedersen.
}
\details{
Quality is a scaled measure of a company's profitability, growth, 
safety, and payouts. By using publicly available data for 
company balance sheets, income statements, and cash flows, \strong{qmj} 
calculates relative quality z-scores for companies. 

All functions and datasets are documented, and are freely 
available for use.
Index of datasets:
\itemize{
 \item companies_r3k16 - A data frame of publicly traded companies in the Russell 
 3000 Index.
 \item financials_r3k16 - Financial statements for companies in the 
 companies_r3k16 dataset.
 \item prices_r3k16 - Daily prices and price returns for the past two years for
 each company.
 \item quality_r3k16 - Measured quality z-scores and component scores
}
}
\references{
Asness, Clifford S., Andrea Frazzini, and Lasse H. Pedersen. 'Quality Minus Junk.' AQR (2013)
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/anttsou/qmj/issues}
}

}
\author{
\strong{Maintainer}: Yanrong Song \email{yrsong129@gmail.com}

Authors:
\itemize{
  \item Anthoney Tsou \email{anttsou@gmail.com}
  \item Eugene Choe \email{ec7@williams.edu}
  \item David Kane \email{dave.kane@gmail.com}
  \item Ryan Kwon \email{rynkwn@gmail.com}
  \item Zijie Zhu \email{zijie.miller.zhu@gmail.com}
}

}
