% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_helpers.R
\name{number_format_style}
\alias{number_format_style}
\title{Number Formats Used by \code{\link[=any_table]{any_table()}}}
\usage{
number_format_style(
  pct_excel = "0.0",
  freq_excel = "#,###,##0",
  freq.g0_excel = "#,###,##0",
  sum_excel = "#,###,##0",
  sum.wgt_excel = "#,###,##0",
  mean_excel = "#,###,##0",
  median_excel = "#,###,##0",
  mode_excel = "#,###,##0",
  min_excel = "#,###,##0",
  max_excel = "#,###,##0",
  sd_excel = "#,###,##0.000",
  variance_excel = "#,###,##0.000",
  first_excel = "#,###,##0",
  last_excel = "#,###,##0",
  p_excel = "#,###,##0",
  missing_excel = "#,###,##0",
  pct_decimals = 1,
  freq_decimals = 0,
  freq.g0_decimals = 0,
  sum_decimals = 3,
  sum.wgt_decimals = 3,
  mean_decimals = 2,
  median_decimals = 2,
  mode_decimals = 2,
  min_decimals = 2,
  max_decimals = 2,
  sd_decimals = 3,
  variance_decimals = 3,
  first_decimals = 0,
  last_decimals = 0,
  p_decimals = 2,
  missing_decimals = 0
)
}
\arguments{
\item{pct_excel}{Number format for percentage applied in Excel workbook.}

\item{freq_excel}{Number format for frequency applied in Excel workbook.}

\item{freq.g0_excel}{Number format for frequency greater zero applied in Excel workbook.}

\item{sum_excel}{Number format for sum applied in Excel workbook.}

\item{sum.wgt_excel}{Number format for sum of weights applied in Excel workbook.}

\item{mean_excel}{Number format for mean applied in Excel workbook.}

\item{median_excel}{Number format for median applied in Excel workbook.}

\item{mode_excel}{Number format for mode applied in Excel workbook.}

\item{min_excel}{Number format for min applied in Excel workbook.}

\item{max_excel}{Number format for max applied in Excel workbook.}

\item{sd_excel}{Number format for sd applied in Excel workbook.}

\item{variance_excel}{Number format for variance applied in Excel workbook.}

\item{first_excel}{Number format for first applied in Excel workbook.}

\item{last_excel}{Number format for last applied in Excel workbook.}

\item{p_excel}{Number format for percentile applied in Excel workbook.}

\item{missing_excel}{Number format for missing applied in Excel workbook.}

\item{pct_decimals}{Number of decimals for percentage.}

\item{freq_decimals}{Number of decimals for frequency.}

\item{freq.g0_decimals}{Number of decimals for frequency greater zero.}

\item{sum_decimals}{Number of decimals for sum.}

\item{sum.wgt_decimals}{Number of decimals for sum of weights.}

\item{mean_decimals}{Number of decimals for mean.}

\item{median_decimals}{Number of decimals for median.}

\item{mode_decimals}{Number of decimals for mode.}

\item{min_decimals}{Number of decimals for min.}

\item{max_decimals}{Number of decimals for max.}

\item{sd_decimals}{Number of decimals for sd.}

\item{variance_decimals}{Number of decimals for variance.}

\item{first_decimals}{Number of decimals for first.}

\item{last_decimals}{Number of decimals for last.}

\item{p_decimals}{Number of decimals for percentile.}

\item{missing_decimals}{Number of decimals for missing.}
}
\value{
Returns a list of named number format options.
}
\description{
Set individual number formats for the different statistics in tables produced
with \code{\link[=any_table]{any_table()}}.
}
\details{
\code{\link[=number_format_style]{number_format_style()}} is based on 'SAS' number formats and the Output Delivery
System (ODS), which provides efficient and readable ways to set up different table
styles.

With the number format style you have full control over formatting numbers according
to the different statistics. There is no need to think about calculating the right
place to input the number formats and how to do this in a loop for multiple cells.
Just input the different number formats and decimals for the different statistics
and everything else is handled by the functions capable of using number styles.

The concept basically is: design over complex calculations.
}
\examples{
# For default values
format_list <- number_format_style()

# Set specific options, the rest will be set to default values
format_list <- number_format_style(pct_excel    = "0.00000000",
                                   pct_decimals = 8)

# IMPORTANT: Don't forget to add individual formats to an excel style, otherwise
# they won't come into affect.
excel_style <- excel_output_style(number_formats = format_list)

}
\seealso{
Creating a custom table style: \code{\link[=excel_output_style]{excel_output_style()}}, \code{\link[=modify_output_style]{modify_output_style()}},
\code{\link[=modify_number_formats]{modify_number_formats()}}.

Global style options: \code{\link[=set_style_options]{set_style_options()}}, \code{\link[=set_variable_labels]{set_variable_labels()}}, \code{\link[=set_stat_labels]{set_stat_labels()}}.

Functions that can handle styles: \code{\link[=frequencies]{frequencies()}}, \code{\link[=crosstabs]{crosstabs()}}, \code{\link[=any_table]{any_table()}},
\code{\link[=export_with_style]{export_with_style()}}
}
