% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qopt.R
\name{qopt}
\alias{qopt}
\title{qs2 Option Getter/Setter}
\usage{
qopt(parameter, value = NULL)
}
\arguments{
\item{parameter}{A character string specifying the option to access. Must be one of
"compress_level", "shuffle", "nthreads", "validate_checksum", "warn_unsupported_types",
or "use_alt_rep".}

\item{value}{If \code{NULL} (the default), the current value is retrieved.
Otherwise, the global option is set to \code{value}.}
}
\value{
If \code{value} is \code{NULL}, returns the current value of the specified option.
Otherwise, sets the option and returns the new value invisibly.
}
\description{
Get or set a global qs2 option.
}
\details{
This function provides an interface to retrieve or update internal qs2 options
such as compression level, shuffle flag, number of threads, checksum validation,
warning for unsupported types, and ALTREP usage. It directly calls the underlying
C-level functions.

The default settings are:
\itemize{
\item \code{compress_level}: 3L
\item \code{shuffle}: TRUE
\item \code{nthreads}: 1L
\item \code{validate_checksum}: FALSE
\item \code{warn_unsupported_types}: TRUE (used only in \code{qd_save})
\item \code{use_alt_rep}: FALSE (used only in \code{qd_read})
}

When \code{value} is \code{NULL}, the current value of the specified option is returned.
Otherwise, the option is set to \code{value} and the new value is returned invisibly.
}
\examples{
# Get the current compression level:
qopt("compress_level")

# Set the compression level to 5:
qopt("compress_level", value = 5)

# Get the current shuffle setting:
qopt("shuffle")

# Get the current setting for warn_unsupported_types (used in qd_save):
qopt("warn_unsupported_types")

# Get the current setting for use_alt_rep (used in qd_read):
qopt("use_alt_rep")

}
