% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_targets.R
\name{pseudo_list}
\alias{pseudo_list}
\title{Specify a pseudo-target within a given class}
\usage{
pseudo_list(family, params, lb = -Inf, ub = Inf, log_p = FALSE, name = NULL)
}
\arguments{
\item{family}{String identifying the distribution family. One of \code{t}, \code{cauchy},
\code{normal}, \code{logistic}, and \code{beta}.}

\item{params}{Named list identifying parameters, which vary by distribution family.

\code{t}: location \code{loc}, scale \code{sc}, and degrees of freedom \code{degf}

\code{cauchy}: location \code{loc} and scale \code{sc}

\code{norm}: location \code{loc} and scale \code{sc}

\code{logistic}: location \code{loc} and scale \code{sc}

\code{beta}: scale \code{scale1} and scale \code{scale2}}

\item{lb}{Numeric scalar giving the value of left truncation. Defaults to \code{-Inf}. Not operative in family \code{beta}.}

\item{ub}{Numeric scalar giving the value of right truncation. Defaults to \code{Inf}. Not operative in family \code{beta}.}

\item{log_p}{(Not implemented) Logical: evaluate distribution and quantile functions using the log probability.}

\item{name}{String appending optional message to the textual name of the distribution.}
}
\value{
A list with named components:

\code{d}: function to evaluate the density

\code{ld}: function to evaluate the log density

\code{q}: function to evaluate the quantile function

\code{p}: function to evaluate the distribution function

\code{txt}: text description of the distribution

\code{params}: repeats the \code{params} argument

\code{lb}: lower boundary of support

\code{ub}: upper boundary of support
}
\description{
Create a list of functions to evaluate a pseudo-target in a given class
with supplied parameters (usually location and scale). The distribution is optionally
truncated to specified bounds (and renormalized). See Heiner et al. (2024+).
}
\details{
The supported classes of pseudo-targets include: \code{t}, \code{cauchy},
\code{normal}, \code{logistic}, and \code{beta}.
}
\examples{
pseu <- pseudo_list(family = "t", params = list(loc = 0.0, sc = 1.0, degf = 5),
                    lb = 0.0, ub = Inf) # half t
str(pseu)
pseu$d(1.5)
pseu$ld(1.5)
pseu$p(1.5)
pseu$q(0.8060963)
pseu <- pseudo_list(family = "cauchy", params = list(loc = 0.0, sc = 1.0),
                    lb = 0.0, ub = Inf) # half Cauchy
str(pseu)
pseu$d(1.5)
pseu$ld(1.5)
pseu$p(1.5)
pseu$q(0.6256659)
pseu <- pseudo_list(family = "normal", params = list(loc = 0.0, sc = 1.0),
                    lb = 0.0, ub = Inf) # half normal
str(pseu)
pseu$d(1.5)
pseu$ld(1.5)
pseu$p(1.5)
pseu$q(0.8663856)
pseu <- pseudo_list(family = "logistic", params = list(loc = 0.0, sc = 1.0),
                    lb = 0.0, ub = Inf) # half logistic
str(pseu)
pseu$d(1.5)
pseu$ld(1.5)
pseu$p(1.5)
pseu$q(0.635149)
pseu <- pseudo_list(family = "beta", params = list(shape1 = 2.0, shape2 = 1.0))
str(pseu)
pseu$d(0.5)
pseu$ld(0.5)
pseu$p(0.5)
pseu$q(0.25)
}
\references{
Heiner, M. J., Johnson, S. B., Christensen, J. R., and Dahl, D. B. (2024+), "Quantile Slice Sampling," \emph{arXiv preprint arXiv:###}
}
