% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qlm.R
\name{qlm}
\alias{qlm}
\title{Quick Linear Regression}
\usage{
qlm(data, V_dependent, signifi = 0.05, vifl = 5, subset = NULL,
  weights = NULL, na.action = NULL, method = "qr", model = TRUE,
  x = FALSE, y = FALSE, qr = TRUE, singular.ok = TRUE,
  contrasts = NULL, offset = NULL)
}
\arguments{
\item{data}{is data set name (e.g. bank)}

\item{V_dependent}{is dependent variable name. No need of double quotes.}

\item{signifi}{is significant level in lm model.(e.g. 0.05,0.01) (default to 0.05)}

\item{vifl}{is variance-inflation level. (default to 5)}

\item{subset}{Existing lm() function argument, an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{Existing lm() function argument, an optional vector of weights to be used in the fitting process. Should be NULL or a numeric vector. If non-NULL, weighted least squares is used with weights weights (that is, minimizing sum(w*e^2)); otherwise ordinary least squares is used.}

\item{na.action}{Existing lm() function argument, a function which indicates what should happen when the data contain NAs. The default is set by the na.action setting of options, and is na.fail if that is unset. The ‘factory-fresh’ default is na.omit. Another possible value is NULL, no action. Value na.exclude can be useful.}

\item{method}{Existing lm() function argument, the method to be used; for fitting, currently only method = "qr" is supported; method = "model.frame" returns the model frame (the same as with model = TRUE).}

\item{model, x, y, qr}{Existing lm() function argument, logicals. If TRUE the corresponding components of the fit (the model frame, the model matrix, the response, the QR decomposition) are returned.}

\item{singular.ok}{Existing lm() function argument, logical. If FALSE (the default in S but not in R) a singular fit is an error.}

\item{contrasts}{Existing lm() function argument, an optional list.}

\item{offset}{Existing lm() function argument, this can be used to specify an a priori known component to be included in the linear predictor during fitting. This should be NULL or a numeric vector of length equal to the number of cases. One or more offset terms can be included in the formula instead or as well, and if more than one are specified their sum is used.}
}
\description{
\code{} Reduces the independent variables based on specified P value and Variance Inflation Factor (VIF) level, and reduces following manual efforts.\cr
1. Checking VIF first then removing number of independent variables based on the VIF level.\cr
2. Then Checking p-value of remaining independent variables and removing them.\cr
\cr
User can select significance level and VIF level as argument.\cr
\cr
Please note: Function reduces above manual efforts, hence I called it as quick regression.\cr
Also, function uses existing lm() function as is, so it will not improve core lm() function execution.\cr
User can provide existing arguments of lm functions.\cr
\cr
Especially with small data set it would be very handy tool for Linear Model preparation.\cr
}
\examples{
  a<-mtcars[,c(1,3,4,5,6,7)]
  b<-qlm(a,mpg)
  summary(b)
  b<-qlm(a,mpg,signifi =0.20)
  summary(b)
  b<-qlm(a,mpg,signifi =0.20,vifl=20)
  summary(b)
}
\keyword{qlm}
