% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{cartesian}
\alias{cartesian}
\title{Adjacency Matrix of the Cartesian Product}
\usage{
cartesian(G, H = NULL)
}
\arguments{
\item{G}{adjacency matrix of the first graph.}

\item{H}{adjacency matrix of the second graph. If not provided,
it takes the same value as \code{G}.}
}
\value{
Let \eqn{A(G),\ A(H)} be the adjacency matrices of
the graphs \eqn{G,\ H} such that \eqn{|V(G)| = n} and \eqn{|V(H)| = m},
then the adjacency matrix of the cartesian product \eqn{G \times H} is
given by

\deqn{A(G \times H) = A(G) \otimes I_{m\ x\ m} + I_{n\ x\ n} \otimes A(H)}
}
\description{
Returns the adjacency matrix of the cartesian product of two graphs
given the adjacency matrix of each one, \eqn{G} and \eqn{H}.
}
\examples{
P3 <- matrix(c(0,1,0,1,0,1,0,1,0), nrow=3)
K3 <- matrix(c(0,1,1,1,0,1,1,1,0), nrow=3)

# Return the adjacency matrix of P3 X K3
cartesian(P3, K3)

# Return the adjacency matrix of P3 X P3
cartesian(P3)
}
\seealso{
\code{\link[=J]{J()}}, \code{\link[=tr]{tr()}}, \code{\link[=trdot]{trdot()}}
}
