% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSplotting.R
\name{plot3js}
\alias{plot3js}
\title{3D scatter / line plot}
\usage{
plot3js(
  x,
  y,
  z,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  label = NULL,
  type = "points",
  geometry = NULL,
  axislabel_line = 3,
  aspect = NULL,
  label_axes = c("x", "y", "z"),
  draw_box = TRUE,
  draw_grid = TRUE,
  grid_lwd = 1,
  grid_col = "grey90",
  axis_lwd = grid_lwd,
  box_lwd = grid_lwd,
  box_col = grid_col,
  background = "#ffffff",
  ...
)
}
\arguments{
\item{x}{x coords for points / lines}

\item{y}{y coords for points / lines}

\item{z}{z coords for points / lines}

\item{xlim}{plot x limits}

\item{ylim}{plot y limits}

\item{zlim}{plot z limits}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{zlab}{z axis label}

\item{label}{optional vector of interactive point labels}

\item{type}{one of "points" or "lines"}

\item{geometry}{should points and lines be represented as physical
geometries? Default for points is TRUE and for lines is FALSE, see
\code{points()} and \code{lines()} for more information.}

\item{axislabel_line}{Distance of axis label from plot}

\item{aspect}{Plot axis aspect ratio, see \code{plot3js.window()}}

\item{label_axes}{Vector of axes to label, any combination of "x", "y" and
"z"}

\item{draw_box}{Should a box be drawn around the plot}

\item{draw_grid}{Should an axis grid be drawn in the background}

\item{grid_lwd}{Grid line width}

\item{grid_col}{Grid line color}

\item{axis_lwd}{Axis line width}

\item{box_lwd}{Box line width}

\item{box_col}{Box color}

\item{background}{Background color for the plot}

\item{...}{Further parameters to pass to \code{material3js()}}
}
\value{
Returns a data3js object, that can be plotted as a widget using
\code{print()} or \code{r3js()} or further added to with the other plotting
functions.
}
\description{
A high level method for generating a 3D scatter or line plot.
}
\examples{

# Simple plot example
p <- plot3js(
  x = iris$Sepal.Length,
  y = iris$Sepal.Width,
  z = iris$Petal.Length,
  col = rainbow(3)[iris$Species],
  xlab = "Sepal Length",
  ylab = "Sepal Width",
  zlab = "Petal Length"
)

r3js(p, zoom = 2)

# Plotting with point rollover info and highlighting
p <- plot3js(
  x = USJudgeRatings$CONT,
  y = USJudgeRatings$INTG,
  z = USJudgeRatings$DMNR,
  highlight = list(
    col = "darkgreen",
    size = 2.5
  ),
  xlab = "CONT",
  ylab = "INTG",
  zlab = "DMNR",
  size = 2,
  col = "green",
  label = rownames(USJudgeRatings)
)

r3js(p, zoom = 2)

}
