% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSobjects.R
\name{sphere3js}
\alias{sphere3js}
\title{Add a sphere of defined radius to a data3js object}
\usage{
sphere3js(data3js, x, y, z, radius, col = "black", highlight, ...)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{x coordinate of the sphere center}

\item{y}{y coordinate of the sphere center}

\item{z}{z coordinate of the sphere center}

\item{radius}{sphere radius}

\item{col}{color}

\item{highlight}{highlight attributes (see \code{highlight3js()})}

\item{...}{other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Unlike points3js, where geometric points can also be represented as
spheres, this adds sphere that is sized with respect to the actual
dimensions of the plotting space (and so if aspect ratios differ for
each axis may not actually appear sphere-like).
}
\examples{
# Setup base plot
p <- plot3js(
  xlim = c(-10, 10),
  ylim = c(-5, 5),
  zlim = c(-8, 8)
)

# Add sphere (this will look distorted because of axis scaling)
p <- sphere3js(
  data3js = p,
  0, 0, 0,
  radius = 5,
  col = "green"
)

r3js(p, zoom = 2.5)

# Setup base plot with equal aspect ratio
p <- plot3js(
  xlim = c(-10, 10),
  ylim = c(-5, 5),
  zlim = c(-8, 8),
  aspect = c(1, 1, 1)
)

# Add sphere (fixed aspect ratio now makes the sphere look spherical)
p <- sphere3js(
  data3js = p,
  0, 0, 0,
  radius = 5,
  col = "green"
)

r3js(p, zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
