% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup_prop_tab.R
\name{lineup_prop_tab}
\alias{lineup_prop_tab}
\title{Lineup proportion}
\usage{
lineup_prop_tab(lineup_table, target_pos)
}
\arguments{
\item{lineup_table}{A table of lineup choices}

\item{target_pos}{A scalar, representing target position in lineup. Must be declared by user}
}
\value{
Returns a proportion indicating the frequency with which a lineup
       member was selected
}
\description{
Computes the proportion of mock witnesses identifying a particular lineup member
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1))
lineup_table <- table(lineup_vec)

#Call:
lineup_prop_tab(lineup_table, 3)
lineup_prop_tab(table(lineup_vec), 2)

}
\references{
Wells, G. L.,Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           empirically assessing the fairness of a lineup. \emph{Law and Human Behavior,
           3}(4), 285-293.
}
