% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotComps.R
\name{SSplotComps}
\alias{SSplotComps}
\title{Plot composition data and fits.}
\usage{
SSplotComps(
  replist,
  subplots = c(1:10, 21, 24),
  kind = "LEN",
  sizemethod = 1,
  aalyear = -1,
  aalbin = -1,
  plot = TRUE,
  print = FALSE,
  fleets = "all",
  fleetnames = "default",
  sexes = "all",
  yupper = 0.4,
  datonly = FALSE,
  samplesizeplots = TRUE,
  compresidplots = TRUE,
  bub = FALSE,
  showyears = TRUE,
  showsampsize = TRUE,
  showeffN = TRUE,
  aggregates_by_mkt = FALSE,
  sampsizeline = FALSE,
  effNline = FALSE,
  minnbubble = 3,
  pntscalar = NULL,
  scalebubbles = FALSE,
  cexZ1 = 1.5,
  bublegend = TRUE,
  colvec = c(rgb(1, 0, 0, 0.7), rgb(0, 0, 1, 0.7), rgb(0.1, 0.1, 0.1, 0.7)),
  linescol = c(rgb(0, 0.5, 0, 0.7), rgb(0.8, 0, 0, 0.7), rgb(0, 0, 0.8, 0.7)),
  xlas = 0,
  ylas = NULL,
  axis1 = NULL,
  axis2 = NULL,
  axis1labs = NULL,
  sizebinlabs = NULL,
  blue = rgb(0, 0, 1, 0.7),
  red = rgb(1, 0, 0, 0.7),
  pwidth = 6.5,
  pheight = 6.5,
  punits = "in",
  ptsize = 10,
  res = 300,
  plotdir = "default",
  cex.main = 1,
  linepos = 1,
  fitbar = FALSE,
  do.sqrt = TRUE,
  smooth = TRUE,
  cohortlines = c(),
  labels = c("Length (cm)", "Age (yr)", "Year", "Observed sample size",
    "Effective sample size", "Proportion", "cm", "Frequency", "Weight", "Length", "(mt)",
    "(numbers x1000)", "Stdev (Age)", "Conditional AAL plot, ", "Size bin"),
  printmkt = TRUE,
  printsex = TRUE,
  maxrows = 6,
  maxcols = 4,
  maxrows2 = 4,
  maxcols2 = 4,
  rows = 1,
  cols = 1,
  andre_oma = c(3, 0, 3, 0),
  andrerows = 4,
  fixdims = TRUE,
  fixdims2 = FALSE,
  maxneff = 5000,
  verbose = TRUE,
  scalebins = FALSE,
  addMeans = TRUE,
  mainTitle = FALSE,
  ...
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{subplots}{vector controlling which subplots to create
Numbering of subplots is as follows, where subplots 21 to 24
(aggregated across years) are provided first, and subplots
1 to 10 are all repeated for each fleet
\itemize{
\item 1 index data by fleet
\item 1 multi-panel composition plot
\item 2 single panel bubble plot for numbers at length or age
\item 3 multi-panel bubble plots for conditional age-at-length
\item 4 multi-panel plot of fit to conditional age-at-length for specific years
\item 5 Pearson residuals for A-L key
\item 6 multi-panel plot of point and line fit to conditional
age-at-length for specific length bins
\item 7 sample size plot
\item 8 TA1.8 Francis weighting plot
\item 9 TA1.8 Francis weighting plot for conditional data
\item 10 Andre's mean age and std. dev. in conditional AAL
\item 21 composition by fleet aggregating across years
\item 22 composition by fleet aggregating across years within each season
\item 23 composition by fleet aggregating across seasons within a year
\item 24 bubble plot comparison of length or age residuals
}}

\item{kind}{indicator of type of plot can be "LEN", "SIZE", "AGE", "cond",
"GSTAGE", "GSTLEN", "L@A", or "W@A".}

\item{sizemethod}{if kind = "SIZE" then this switch chooses which of the
generalized size bin methods will be plotted.}

\item{aalyear}{Years to plot multi-panel conditional age-at-length fits for
all length bins; must be in a "c(YYYY,YYYY)" format. Useful for checking the
fit of a dominant year class, critical time period, etc. Default=-1.}

\item{aalbin}{The length bin for which multi-panel plots of the fit to
conditional age-at-length data will be produced for all years.  Useful to
see if growth curves are ok, or to see the information on year classes move
through the conditional data. Default=-1.}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{fleets}{optional vector to subset fleets for which plots will be made}

\item{fleetnames}{optional vector of fleet names to put in the labels}

\item{sexes}{which sexes to show plots for. Default="all" which will include
males, females, and unsexed. This option is not fully implemented for all
plots.}

\item{yupper}{upper limit on ymax for polygon/histogram composition plots}

\item{datonly}{make plots of data without fits?}

\item{samplesizeplots}{make sample size plots?}

\item{compresidplots}{make plots of residuals for fit to composition data?}

\item{bub}{make bubble plot for numbers at age or size?}

\item{showyears}{Add labels for years to sample size plots?}

\item{showsampsize}{add sample sizes to plot}

\item{showeffN}{add effective sample sizes to plot}

\item{aggregates_by_mkt}{separate plots of aggregates across years
into different plots for each market category (retained, discarded)?}

\item{sampsizeline}{show line for input sample sizes on top of conditional
age-at-length plots (TRUE/FALSE, still in development)}

\item{effNline}{show line for effective sample sizes on top of conditional
age-at-length plots (TRUE/FALSE, still in development)}

\item{minnbubble}{number of unique x values before adding buffer. see
?bubble3 for more info.}

\item{pntscalar}{This scalar defines the maximum bubble size for bubble
plots. This option is still available but a better choice is to use cexZ1
which allow the same scaling throughout all plots.}

\item{scalebubbles}{scale data-only bubbles by sample size, not just
proportion within sample? Default=FALSE.}

\item{cexZ1}{Character expansion (cex) for point associated with value of 1.}

\item{bublegend}{Add legend with example bubble sizes to bubble plots.}

\item{colvec}{Vector of length 3 with colors for females, males, unsexed fish}

\item{linescol}{Color for lines on top of polygons}

\item{xlas}{label style (las) input for x-axis. Default 0 has horizontal
labels, input 2 would provide vertical lables.}

\item{ylas}{label style (las) input for y-axis. Default NULL has horizontal
labels when all labels have fewer than 6 characters and vertical otherwise.
Input 0 would force vertical labels, and 1 would force horizontal.}

\item{axis1}{optional position of bottom axis values}

\item{axis2}{optional position of left size axis values}

\item{axis1labs}{optional vector of labels for axis1 (either NULL or needs to
match length of axis1)}

\item{sizebinlabs}{Vector of size bin labels corresponding to the generalized
size frequency method}

\item{blue}{What color to use for males in bubble plots (default is slightly
transparent blue)}

\item{red}{What color to use for females in bubble plots (default is slightly
transparent red)}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. The default is \code{pwidth=6.5}.}

\item{pheight}{Height of plots printed to png files in units of \code{punits}.
Default is designed to allow two plots per page, with \code{pheight_tall} used
for plots that work best with a taller format and a single plot per page.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" (centimeters), or "mm" (millimeters).
The default is \code{punits="in"}.}

\item{ptsize}{Point size for plotted text in plots printed to files (see
\code{help("png")} in R for details).}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{cex.main}{character expansion parameter for plot titles}

\item{linepos}{should lines be added before points (linepos=1) or after
(linepos=2)?}

\item{fitbar}{show fit to bars instead of points}

\item{do.sqrt}{scale bubbles based on sqrt of size vector. see ?bubble3 for
more info.}

\item{smooth}{add loess smoother to observed vs. expected index plots and
input vs. effective sample size?}

\item{cohortlines}{optional vector of birth years for cohorts for which to
add growth curves to numbers at length bubble plots}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{printmkt}{show market categories in plot titles?}

\item{printsex}{show sex in plot titles?}

\item{maxrows}{maximum (or fixed) number or rows of panels in the plot}

\item{maxcols}{maximum (or fixed) number or columns of panels in the plot}

\item{maxrows2}{maximum number of rows for conditional age at length plots}

\item{maxcols2}{maximum number of columns for conditional age at length
plots}

\item{rows}{number or rows to return to as default for next plots to come or
for single plots}

\item{cols}{number or cols to return to as default for next plots to come or
for single plots}

\item{andre_oma}{Outer margins passed to Andre's multi-panel conditional
age-at-length plots.}

\item{andrerows}{Number of rows of Andre's conditional age-at-length plots
within each page. Default=3.}

\item{fixdims}{fix the dimensions at maxrows by maxcols or resize based on
number of years of data}

\item{fixdims2}{fix the dimensions at maxrows by maxcols in aggregate plots
or resize based on number of fleets}

\item{maxneff}{the maximum value to include on plots of input and effective
sample size. Occasionally a calculation of effective N blows up to very
large numbers, rendering it impossible to observe the relationship for other
data. Default=5000.}

\item{verbose}{return updates of function progress to the R GUI?}

\item{scalebins}{Rescale expected and observed proportions by dividing by
bin width for models where bins have different widths? Caution!: May not
work correctly in all cases.}

\item{addMeans}{Add parameter means in addition to medians for MCMC
posterior distributions in which the median and mean differ.}

\item{mainTitle}{Logical indicating if a title for the plot should be produced}

\item{\dots}{additional arguments that will be passed to
the \code{par} command in the \code{\link[=make_multifig]{make_multifig()}} function.}
}
\description{
Plot composition data and fits from Stock Synthesis output.  Multi-figure
plots depend on \code{make_multifig}.
}
\seealso{
\code{\link[=SS_plots]{SS_plots()}}, \code{\link[=make_multifig]{make_multifig()}}
}
\author{
Ian Taylor
}
