% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{start_r5r_java}
\alias{start_r5r_java}
\title{Initialize Java and Check Version}
\usage{
start_r5r_java(data_path, temp_dir = FALSE, verbose = FALSE)
}
\arguments{
\item{data_path}{A character string. The directory where the log file should be saved.}

\item{temp_dir}{A logical. Whether the jar file should be saved in a temporary
directory. Defaults to \code{FALSE}.}

\item{verbose}{A logical. Whether to show informative messages. Defaults to \code{FALSE}.}
}
\value{
No return value. The function will stop execution with an error if Java 21 is not found.
}
\description{
Sets up Java logging for r5r and ensures Java SE Development Kit 21 is installed.
}
\details{
This function initializes the Java Virtual Machine (JVM) with a log path for r5r, and checks that
the installed Java version is 21. If not, it stops with an informative error message and download links.
}
\seealso{
Other support functions: 
\code{\link{exists_tiff}()},
\code{\link{fileurl_from_metadata}()},
\code{\link{stop_r5}()},
\code{\link{tempdir_unique}()},
\code{\link{validate_bad_osm_ids}()}
}
\concept{support functions}
\keyword{internal}
