% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.3_Mix_designs_Functions.R
\name{mixDesign}
\alias{mixDesign}
\title{mixDesign: Mixture Designs}
\usage{
mixDesign(
  p,
  n = 3,
  type = "lattice",
  center = TRUE,
  axial = FALSE,
  delta,
  replicates = 1,
  lower,
  total = 1,
  randomize,
  seed = 1234
)
}
\arguments{
\item{p}{Numerical value giving the amount of factors.}

\item{n}{Numerical value specifying the degree (ignored if type = `centroid`).}

\item{type}{Character string giving the type of design. \code{type} can be `lattice` or `centroid` (referencing to the first source under the section references].
By default \code{type} is set to `lattice`.}

\item{center}{Logical value specifying whether (optional) center points will be added.
By default `center` is set to `TRUE`.}

\item{axial}{Logical value specifying whether (optional) axial points will be added.
By default `axial` is set to `FALSE`.}

\item{delta}{Numerical value giving the delta (see references) for axial runs. No default setting.}

\item{replicates}{Vector with the number of replicates for the different design points i.e. c(center = 1, axial = 1, pureBlend = 1, BinaryBlend = 1, p-3 blend, p-2 blend, p-1 blend).
By default `replicates` is set to `1`.}

\item{lower}{Numeric vector of lower-bound constraints on the component proportions (i.e. must be given in percent).}

\item{total}{Numeric vector with
\itemize{
\item {[1] the percentage of the mixture made up by the q - components (e.g. q = 3 and x1 + x2 + x3 = 0.8, total = 0.8 with 0.2 for the other factors being held constant)}
\item {[2] overall total in corresponding units (e.g. 200ml for the overall mixture)}
}}

\item{randomize}{Logical value. If `TRUE` the RunOrder of the mixture design will be randomized (default).}

\item{seed}{Nmerical value giving the input for set.seed.}
}
\value{
The function \code{mixDesig()} returns an object of class \code{mixDesig()}.
}
\description{
Function to generate simplex lattice and simplex centroid mixture designs with optional center points and axial points.
}
\note{
In this version the creation of (augmented) lattice, centroid mixture designs is fully supported. Getters and Setter methods for the mixDesign object exist just as for objects of class \code{facDesign} (i.e. factorial designs).

The creation of constrained component proportions is partially supported but don't rely on it. Visualization (i.e. ternary plots) for some of these designs can be done with the help of the \code{wirePlot3} and \code{contourPlot3} function.
}
\examples{
# Example usage of mixDesign
mdo <- mixDesign(3, 2, center = FALSE, axial = FALSE, randomize = FALSE, replicates = c(1, 1, 2, 3))

mdo$names(c("polyethylene", "polystyrene", "polypropylene"))
elongation <- c(11.0, 12.4, 15.0, 14.8, 16.1, 17.7,
                16.4, 16.6, 8.8, 10.0, 10.0, 9.7,
                11.8, 16.8, 16.0)
mdo$.response(elongation)

mdo$units()
mdo$summary()
}
\seealso{
\code{\link{mixDesign.c}}, \code{\link{facDesign.c}}, \code{\link{facDesign}}, \code{\link{fracDesign}}, \code{\link{rsmDesign}}, \code{\link{wirePlot3}}, \code{\link{contourPlot3}}.
}
