% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amPercentageBarChart.R
\name{amPercentageBarChart}
\alias{amPercentageBarChart}
\title{HTML widget displaying a 100\% stacked bar chart}
\usage{
amPercentageBarChart(
  data,
  category,
  values,
  valueNames = NULL,
  hline = NULL,
  chartTitle = NULL,
  theme = NULL,
  animated = TRUE,
  backgroundColor = NULL,
  xAxis = NULL,
  yAxis = NULL,
  scrollbarX = FALSE,
  scrollbarY = FALSE,
  legend = TRUE,
  caption = NULL,
  image = NULL,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{category}{name of the column of \code{data} to be used on the
category axis}

\item{values}{names of the columns of \code{data} to be used on the
value axis}

\item{valueNames}{names of the values variables, to appear in the legend;
\code{NULL} to use \code{values} as names, otherwise a named list of the
form \code{list(value1 = "ValueName1", value2 = "ValueName2", ...)} where
\code{value1}, \code{value2}, ... are the column names given in
\code{values} and \code{"ValueName1"}, \code{"ValueName2"}, ... are the
desired names to appear in the legend; these names also appear in
the tooltips.}

\item{hline}{an optional horizontal line to add to the chart; it must be a
named list of the form \code{list(value = h, line = settings)} where
\code{h} is the "intercept" and \code{settings} is a list of settings
created with \code{\link{amLine}}}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{animated}{Boolean, whether to animate the rendering of the graphic}

\item{backgroundColor}{a color for the chart background; a color can be
given by the name of a R color, the name of a CSS color, e.g.
\code{"rebeccapurple"} or \code{"fuchsia"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{xAxis}{settings of the category axis given as a list, or just a string
for the axis title; the list of settings has three possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
and a field \code{adjust}, a number defining the vertical adjustment of
the axis (in pixels)}

\item{yAxis}{settings of the value axis given as a list, or just a string
for the axis title; the list of settings has five possible fields:
a field \code{title}, a list of settings for the axis title created
with \code{\link{amText}},
a field \code{labels}, a list of settings for the axis labels created
with \code{\link{amAxisLabels}},
a field \code{adjust}, a number defining the horizontal adjustment of
the axis (in pixels), a field \code{gridLines}, a list of settings for
the grid lines created with \code{\link{amLine}} and a field
\code{breaks} to control the axis breaks, an R object created with
\code{\link{amAxisBreaks}}}

\item{scrollbarX}{logical, whether to add a scrollbar for the category axis}

\item{scrollbarY}{logical, whether to add a scrollbar for the value axis}

\item{legend}{either a logical value, whether to display the legend, or
a list of settings for the legend created with \code{\link{amLegend}}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a 100\% stacked bar chart.
}
\examples{
library(rAmCharts4)

dat <- data.frame(
  category = c("A", "B", "C"),
  v1 = c(1, 2, 3),
  v2 = c(9, 5, 7)
)

amPercentageBarChart(
  dat,
  category = "category",
  values = c("v1", "v2"),
  valueNames = c("Value1", "Value2"),
  yAxis = "Percentage",
  theme = "dataviz",
  legend = amLegend(position = "right")
)
}
