% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance_by_cluster}
\alias{performance_by_cluster}
\title{Compute per-cluster and per-group performance metrics (MSE, BCE)}
\usage{
performance_by_cluster(
  res,
  clusters = NULL,
  group_col = NULL,
  feature_cols = NULL,
  binary_features = character(0),
  by_group = TRUE,
  by_cluster = TRUE,
  cols_ignore = NULL
)
}
\arguments{
\item{res}{A list containing CISS-VAE run outputs. Must include:
\itemize{
\item \code{res$val_data}: validation data frame (with \code{NA} for non-validation cells)
\item \code{res$val_imputed}: model-imputed validation predictions
\item \code{res$clusters}: cluster labels for each row
}}

\item{clusters}{Optional vector (same length as rows in \code{val_data}) of cluster labels.
If \code{NULL}, will use \code{res$clusters}.}

\item{group_col}{Optional character, name of the column in \code{val_data} for grouping.}

\item{feature_cols}{Character vector specifying which feature columns to evaluate. Defaults to all numeric
columns except \code{group_col} and those in \code{cols_ignore}.}

\item{binary_features}{Character vector naming those columns (subset of \code{feature_cols}) that
should use BCE instead of MSE.}

\item{by_group}{Logical; if \code{TRUE} (default), summarize by \code{group_col}.}

\item{by_cluster}{Logical; if \code{TRUE} (default), summarize by cluster.}

\item{cols_ignore}{Character vector of column names to exclude from scoring (e.g., “id”).}
}
\value{
A named list containing:
\itemize{
\item \code{overall}: overall average metric (MSE for continuous, BCE for binary)
\item \code{per_cluster}: summaries by cluster
\item \code{per_group}: summaries by group
\item \code{group_by_cluster}: summaries by group and cluster
\item \code{per_feature_overall}: average per-feature metric
}
}
\description{
Calculates mean squared error (MSE) for continuous features and binary
cross-entropy (BCE) for features you explicitly mark as binary,
comparing model-imputed validation values against ground-truth validation data.
}
\details{
For features listed in \code{binary_features}, performance is binary cross-entropy (BCE):
\deqn{-[y\log(p) + (1-y)\log(1-p)]}.
For other numeric features, performance is mean squared error (MSE).
}
\examples{
library(tidyverse)
library(reticulate)
library(rCISSVAE)
library(kableExtra)
library(gtsummary)

## Make example results
data_complete = data.frame(
index = 1:10,
x1 = rnorm(10),
x2 = rnorm(10)*rnorm(10, mean = 50, sd=10)
 )

missing_mask = matrix(data = c(rep(FALSE, 10), 
sample(c(TRUE, FALSE), 
size = 20, replace = TRUE, 
prob = c(0.7, 0.3))), nrow = 10)

## Example validation dataset
val_data = data_complete
val_data[missing_mask] <- NA

## Example 'imputed' validation dataset
val_imputed = data.frame(index = 1:10, x1 = mean(data_complete$x1), x2 = mean(data_complete$x2))
val_imputed[missing_mask] <- NA

## Example result list
result = list("val_data" = val_data, "val_imputed" = val_imputed)
clusters = sample(c(0, 1), size = 10, replace = TRUE)

## Run the function
performance_by_cluster(res = result, 
  group_col = NULL, 
  clusters = clusters,
  feature_cols = NULL, 
  by_group = FALSE,
  by_cluster = TRUE,
  cols_ignore = c("index") 
)
}
