% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTMHeader.R
\name{DTMHeader}
\alias{DTMHeader}
\title{DTMHeader}
\usage{
DTMHeader(fusion.path = "C:/FUSION/", filename)
}
\arguments{
\item{fusion.path}{Character. By default: C:/FUSION/. Path where the program FUSION is installed.}

\item{filename}{is a character.Name for output canopy surface file (stored in PLANS DTM format with .dtm extension).}
}
\value{
No return value. This function return the command prompt running the FUSION command
}
\description{
DTMHeader is an interactive program. It is described in the Command Line Utility section because it provides a means to examine and modify PLANS DTM file header information. DTMHeader allows you to easily view and change the header information for a PLANS DTM file. To make it most convenient, associate the .dtm extension with DTMHeader so you can simply double-click a .dtm file to view the header. The values in the header that can be modified are:
Planimetric units,
Elevation units,
Descriptive name,
Coordinate system and zone,
Horizontal datum,
Vertical datum.
}
\details{
The ENVI data file is created using the same numeric format as the PLANS DTM file. All PLANS DTM data types are supported. Geo-referencing information is included in the ENVI header file using the “map info” tag.
Areas in the DTM grid that have no data will be “marked” with a value of -9999.0 in the ENVI format file and the appropriate value will be included in the “data ignore value” tag in the ENVI header file.
}
\examples{
filename<-'Z:/filename.dtm'
DTMHeader(filename = filename)
}
\references{
McGaughey, R.J. FUSION/LDV: Software for LIDAR Data Analysis and Visualization. 2021.
}
