% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipality.R
\name{municipality_extract_ids}
\alias{municipality_extract_ids}
\title{Extract a vector of municipality ID strings from a Kolada municipality table}
\usage{
municipality_extract_ids(munic_df)
}
\arguments{
\item{munic_df}{A Kolada Municipality metadata table, as created by e.g.
\code{get_municipality}.}
}
\description{
This function is primarily intended as a convenient way to pass a (filtered)
Kolada municipality metadata table to \code{\link{get_values}}.
}
\examples{
if (kolada_available()) {
# Download Kolada data for all municipalities of type "L"
# (regions and national total) for KPI "N45933"
munic_filter <- get_municipality() \%>\%
  municipality_search("L", column = "type")

kld_data <- get_values(
  kpi = "N45933",
  municipality = municipality_extract_ids(munic_filter),
  period = 2022
)
}

}
