% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_packed_bar.R
\name{plotly_packed_bar}
\alias{plotly_packed_bar}
\title{Create a 'plotly' packed bar chart}
\usage{
plotly_packed_bar(input_data, label_column, value_column,
  number_rows = "guess", plot_title = "", xaxis_label = "",
  hover_label = "", min_label_width = 0.03,
  color_bar_color = "steelblue", label_color = "black")
}
\arguments{
\item{input_data}{data.frame with data to plot, should have a column of labels for bars and column of numbers relating to bar length}

\item{label_column}{either the column number or quoted name in \code{input_data} to be used as labels (will be used by \code{[[} to subset)}

\item{value_column}{either the column number or quoted name in \code{input_data} to be used as numbers for bar lengths (will be used by \code{[[} to subset).  See details.}

\item{number_rows}{The number of rows to occur in barchart (i.e. the number of colored bars).  The default of 'guess' will attempt to find the 'elbow' in the numeric data with a min value of 3 and a max of 25.}

\item{plot_title}{main title for plot}

\item{xaxis_label}{label to put on xaxis}

\item{hover_label}{text to appear by number in hover information (typically same as xaxis label)}

\item{min_label_width}{min relative length of bar to receive a static label (too small and text will overflow sides of bar)}

\item{color_bar_color}{color of main bars in chart (can be name or hex) remaining bars will be variations of gray}

\item{label_color}{color of text labels that appear over colored bars}
}
\value{
'plotly' object of the packed bar chart
}
\description{
Packed bar charts are a variation of treemaps for visualizing skewed data.  The concept was introduced by XanGregg at JMP (\url{https://community.jmp.com/t5/JMP-Blog/Introducing-packed-bars-a-new-chart-form/ba-p/39972}).
}
\details{
The packed barchart currently only works for uniformly positive or uniformly negative data; negative values will be removed before plotting when mixed data is provided.
}
\examples{
\dontrun{
data(GNI2014, package = 'treemap')

data.table::setDT(GNI2014)
my_input_data = GNI2014[,sum(population), by=country]

plotly_packed_bar(my_input_data,
                  label_column    = "country",
                  value_column    = "V1",
                  plot_title      = "Population 2014",
                  xaxis_label     = "Population",
                  hover_label     = "Population",
                  min_label_width = .025,
                  color_bar_color = "orange")
}
}
