% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTRNG-package.R
\docType{package}
\name{rTRNG-package}
\alias{rTRNG}
\alias{rTRNG-package}
\title{TRNG C++ library functionality exposed to R.}
\description{
Tina's Random Number Generator Library (\pkg{TRNG}) is a state-of-the-art C++
pseudo-random number generator library for sequential and parallel Monte
Carlo simulations (\url{https://www.numbercrunch.de/trng/}). It provides a variety
of random number engines (pseudo-random number generators) and distributions.
In particular, \emph{parallel} random number engines provided by TRNG support
techniques such as \emph{block-splitting} and \emph{leapfrogging} suitable
for parallel algorithms. See \sQuote{References} for an introduction to the
concepts and details around (parallel) random number generation.

\if{html}{\figure{rTRNG.svg}{options: height="150" alt="rTRNG"}}

Package \pkg{rTRNG} provides the \R users with access to the functionality of
the underlying TRNG C++ library in different ways and at different levels.
\itemize{
  \item
    Base-\R \link{Random}-like usage via \link{TRNG.Random} functions, for
    selecting and manipulating the current engine. This is the simplest and
    more immediate way for \R users to use \pkg{rTRNG}.
  \item
    \link[=TRNG.Engine]{Reference Objects} wrapping the underlying C++ TRNG
    random number engines can be created and manipulated in OOP-style. This
    allows greater flexibility in using TRNG engines in \R.
  \item
    TRNG C++ library and headers are made available to other \R projects
    and packages using C++.
    \itemize{
    \item
      Standalone C++ code sourced via \code{\link[Rcpp]{sourceCpp}} can rely
      on the \code{\link[Rcpp:dependsAttribute]{Rcpp::depends}} attribute to
      correctly set up building against \pkg{rTRNG}:
      \preformatted{
// [[Rcpp::depends(rTRNG)]]}
    \item
      Creating an \R package with C++ code using the TRNG library is achieved
      by \code{LinkingTo: rTRNG} in the DESCRIPTION file, adding
      \code{importFrom(rTRNG, TRNG.Version)} in the NAMESPACE file, and
      setting relevant linker flags (via \code{\link[rTRNG]{LdFlags}}) in
      Makevars[.win].
    \item
      Note that C++ code using the TRNG library (sourced via
      \code{Rcpp::sourceCpp} or part of an \R package) might fail on certain
      systems due to issues with building and linking against \pkg{rTRNG}.
      This is typically the case for macOS, and can generally be checked
      using
      \code{\link[rTRNG]{check_rTRNG_linking}}.
    }
}
See the package vignettes (\code{browseVignettes("rTRNG")}) for an overview
and demos and refer to the examples in the documentation for further use
cases.
}
\references{
Heiko Bauke, \emph{Tina's Random Number Generator Library}, Version
4.23.1, \url{https://github.com/rabauke/trng4/blob/v4.23.1/doc/trng.pdf}.

Stephan Mertens, \emph{Random Number Generators: A Survival Guide
  for Large Scale Simulations}, 2009,
  \url{https://ui.adsabs.harvard.edu/abs/2009arXiv0905.4238M}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/miraisolutions/rTRNG#readme}
  \item \url{https://mirai-solutions.ch}
  \item Report bugs at \url{https://github.com/miraisolutions/rTRNG/issues}
}

}
\author{
\strong{Maintainer}: Riccardo Porreca \email{riccardo.porreca@mirai-solutions.com}

Authors:
\itemize{
  \item Roland Schmid \email{roland.schmid@mirai-solutions.com}
}

Other contributors:
\itemize{
  \item Mirai Solutions GmbH \email{info@mirai-solutions.com} [copyright holder]
  \item Heiko Bauke (TRNG sources and headers) [contributor, copyright holder]
}

}
