% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racircal.R
\name{racircal}
\alias{racircal}
\title{Corrects rapid A/Ci response (RACiR) data from leaves using empty chamber
data.}
\usage{
racircal(
  data,
  caldata,
  mincut,
  maxcut,
  title,
  varnames = list(A = "A", Ca = "Ca", CO2_r = "CO2_r", E = "E", gtc = "gtc")
)
}
\arguments{
\item{data}{Data frame with the RACiR response data}

\item{caldata}{Data frame with the calibration data}

\item{mincut}{Minimum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the initial chamber mixing. Default value is set to the
minimum COR_r value.}

\item{maxcut}{Maximum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the end of the response. Not needed in all cases. Default
value is set to the maximum COR_r value.}

\item{title}{Title of output graph - useful for batch RACiR corrections.}

\item{varnames}{Variable names - this allows for the use of this code with
other machines and setups where variable names may differ.}
}
\value{
racircal returns a data frame with corrected RACiR data
}
\description{
\code{racircal} Corrects your RACiR data based on calibration data. Produces
corrected A vs. Ci graph. Output is a data frame with corrected RACiR data
using variable names Acor and Cicor for the corrected A and Ci values.
}
\examples{
\donttest{
#Read in data
data <- read_6800(system.file("extdata", "poplar_2", package = "racir"))
caldata <- read_6800(system.file("extdata", "cal", package = "racir"))
#Correct data
data_corrected <- racircal(data = data, caldata = caldata,
                           mincut = 350, maxcut = 780, title = "Test")
}

}
