% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_hyper}
\alias{r_hyper}
\title{Generate Hypergeometric Distributed Values}
\usage{
r_hyper(
  total,
  positives,
  num,
  ...,
  n = default_n(total, positives, num),
  .seed = NULL
)
}
\arguments{
\item{total}{size of the population (e.g. number of balls)}

\item{positives}{number of elements with the desirable feature (e.g number of black balls)}

\item{num}{number of draws to make}

\item{...}{Unused}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Hypergeometric distributed values.
}
\examples{

set_n(5)

r_hyper(10, 5, 5)

r_hyper(10:20, 10, 5)

r_hyper(10, 5, 5, n = 10)
}
