% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srt_data.r
\name{srt_data}
\alias{srt_data}
\alias{srt_data.numeric}
\alias{srt_data.data.frame}
\title{Get data for the signed-rank test.}
\usage{
srt_data(x, ...)

\method{srt_data}{numeric}(x, y = NULL, x_name, y_name = NULL, ...)

\method{srt_data}{data.frame}(x, formula, agg_fun = "error", ...)
}
\arguments{
\item{x}{(numeric)\cr
Numeric vector or data.frame of data.
Values with non-finite values (infinite or missing) are silently dropped.}

\item{...}{Unused additional arguments.}

\item{y}{(numeric: \code{NULL})\cr
Numeric vector of data or \code{NULL}.
If \code{NULL} (default), a one-sample test is performed using \code{x}.
If numeric, differences are calculated as \code{x - y}.
Pairs with non-finite values (infinite or missing) are silently dropped.}

\item{x_name}{(Scalar character)\cr
Name of \code{x} variable.}

\item{y_name}{(Scalar character or \code{NULL})\cr
Name of \code{y} variable.
If \code{y = NULL} then \code{y_name = NULL}.}

\item{formula}{(formula)\cr
A formula of form:
\describe{
\item{y ~ group | block}{
Use when \code{data} is in tall format.
\code{y} is the numeric outcome, \code{group} is the binary grouping variable, and \code{block} is the subject/item-level variable indicating pairs of observations.
\code{group} will be converted to a factor and the first level will be the reference value.
For example, when \code{levels(data$group) <- c("pre", "post")}, the focal level is 'post', so differences are \code{post - pre}.
Pairs with non-finite values (infinite or missing) are silently dropped.
See \code{agg_fun} for handling duplicate cases of grouping/blocking combinations.
}
\item{y ~ x}{
Use when \code{data} is in wide format.
\code{y} and \code{x} must be numeric vectors.
Differences are calculated as \code{data$y - data$x}.
Pairs with non-finite values (infinite or missing) are silently dropped.
}
\item{ ~ x}{
Use when \code{data$x} represents pre-calculated differences or for the one-sample case.
Values with non-finite values (infinite or missing) are silently dropped.
}
}}

\item{agg_fun}{(Scalar character or function: \code{"error"})\cr
Used for aggregating duplicate cases of grouping/blocking combinations when data is in tall format and \code{formula} has structure \code{y ~ group | block}.
\code{"error"} (default) will return an error if duplicate grouping/blocking combinations are encountered.
Select one of \code{"first"}, \code{"last"}, \code{"sum"}, \code{"mean"}, \code{"median"}, \code{"min"}, or \code{"max"} for built in aggregation handling (each applies \code{na.rm = TRUE}).
Or define your own function.
For example, \code{myfun <- function(x) {as.numeric(quantile(x, 0.75, na.rm = TRUE))}}.}
}
\value{
list
}
\description{
Gets data needed to compute signed-rank results.
The returned list is designed to be reused by higher-level functions.
}
\keyword{internal}
