% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{foodAAT}
\alias{foodAAT}
\title{Approach-Avoidance Task examining approach bias to different foods}
\format{
An object of class \code{"data.frame"}.
}
\source{
\doi{10.1016/j.appet.2018.01.032}
}
\usage{
data(foodAAT, package="rapidsplithalf")
}
\description{
This data originates from an approach-avoidance task examining approach bias towards food.
Participants responded to the stimulus category (food or object) by pulling or pushing a joystick.
Instructions were flipped from one block to the next.
}
\details{
\itemize{
\item subjectid: Participant ID.
\item stimid: Stimulus ID.
\item is_pull: Whether the trial required an approach response (1) or an avoid response (0).
\item is_target: Whether the trial featured a food stimulus (1) or an object stimulus (0).
\item error: Whether the response was incorrect (1) or correct (0).
\item RT: The response initiation time.
\item FullRT: The time from stimulus onset to response completion.
\item trialnum: The trial number.
\item blocknum: The block number.
\item palatability: The participant's palatability rating for the stimulus (foods only).
\item valence: The participant's valence rating for the stimulus.
\item FCQS_2_craving: The participant's FCQS state food craving score at time of testing.
\item FCQS_2_hunger: The participant's FCQS state hunger score at time of testing.
}
}
\references{
Lender, A., Meule, A., Rinck, M., Brockmeyer, T., & Blechert, J. (2018).
Measurement of food-related approach–avoidance biases:
Larger biases when food stimuli are task relevant. Appetite, 125, 42–47.
\doi{10.1016/j.appet.2018.01.032}
}
\keyword{datasets}
