% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl_get_campaign_report.R
\name{apl_get_campaign_report}
\alias{apl_get_campaign_report}
\title{Get Campaign-Level Reports}
\usage{
apl_get_campaign_report(
  org_id = apl_get_me_details()$parentOrgId,
  start_date = Sys.Date() - 8,
  end_date = Sys.Date() - 1,
  group_by = NULL,
  granularity = c("DAILY", "HOURLY", "WEEKLY", "MONTHLY")
)
}
\arguments{
\item{org_id}{The value is your orgId.}

\item{start_date}{Start reporting date}

\item{end_date}{End reporting date}

\item{group_by}{Use the groupBy field to group responses by selected dimensions. If groupBy specifies age, gender, and geodimensions}

\item{granularity}{The report data organized by hour, day, week, and month.}
}
\value{
tibble with report data
}
\description{
Get Campaign-Level Reports
}
\examples{
\dontrun{
camp_rep <- apl_get_campaign_report(
  org_id     = 2623170,
  start_date = '2025-07-20',
  end_date   = '2025-07-26',
  group_by   = 'countryOrRegion'
)
}
}
