% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moverci.R
\name{moverci}
\alias{moverci}
\title{Method of Variance Estimates Recovery ("MOVER") confidence intervals
for comparisons of independent binomial or Poisson rates.}
\usage{
moverci(
  x1,
  n1,
  x2 = NULL,
  n2 = NULL,
  distrib = "bin",
  contrast = "RD",
  level = 0.95,
  a1 = 0.5,
  b1 = 0.5,
  a2 = 0.5,
  b2 = 0.5,
  type = "jeff",
  adj = FALSE,
  cc = FALSE,
  ...
)
}
\arguments{
\item{x1, x2}{Numeric vectors of numbers of events in group 1 & group 2
respectively.}

\item{n1, n2}{Numeric vectors of sample sizes (for binomial rates) or exposure
times (for Poisson rates) in each group.}

\item{distrib}{Character string indicating distribution assumed for the input
data:\cr
"bin" = binomial (default);\cr
"poi" = Poisson.}

\item{contrast}{Character string indicating the contrast of interest: \cr
"RD" = rate difference (default); \cr
"RR" = rate ratio; \cr
"OR" = odds ratio; \cr
"p" gives an interval for the single proportion \code{x1/n1}.}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{a1, b1, a2, b2}{Numbers defining the Beta(ai,bi) prior distributions for
each group (default ai = bi = 0.5 for Jeffreys method). Gamma priors for
Poisson rates require only a1, a2.}

\item{type}{Character string indicating the method used for the intervals for
the individual group rates. \cr
"jeff" = Jeffreys equal-tailed intervals (default); \cr
"exact" = Clopper-Pearson/Garwood exact intervals (note this does NOT
result in a strictly conservative interval for the contrast, except for
contrast = "p". The scoreci function with \code{cc = TRUE} is recommended as a
superior approximation of 'exact' methods); \cr
"midp" = mid-p intervals; \cr
"SCAS" = SCAS non-iterative intervals; \cr
"wilson" = Wilson score intervals (as per Newcombe 1998).
(Rao score is used for \code{distrib = "poi"}) \cr
NB: "wilson" option is included only for legacy validation against previous
published method by Newcombe. It is not recommended, as \code{type = "jeff"}
or other equal-tailed options achieve much better coverage properties.}

\item{adj}{Logical (default FALSE) indicating whether to apply the boundary
adjustment for Jeffreys intervals recommended on p108 of Brown et al.
(\code{type = "jeff"} only: set to FALSE if using informative priors.)}

\item{cc}{Number or logical specifying (amount of) continuity adjustment
(default FALSE). Numeric value is taken as the gamma parameter in Laud
2017, Appendix S2 (default 0.5 if \code{cc = TRUE}). Forced equal to 0.5 if
\code{type = "exact"}.}

\item{...}{Additional arguments.}
}
\value{
A list containing the following components: \describe{
\item{estimates}{a matrix containing estimates of the rates in each group
and of the requested contrast, with its confidence interval.}
\item{call}{details of the function call.} }
}
\description{
Confidence intervals applying the MOVER method ("Method of Variance Estimates
Recovery", developed from the Newcombe method for binomial RD) across
different contrasts (RD, RR, OR) and distributions (binomial, Poisson) using
equal-tailed Jeffreys intervals instead of the Wilson score method for the
event rates.  Also allows more general Beta and Gamma priors for an
approximate Bayesian confidence interval incorporating prior beliefs about
the group event rates.
This function is vectorised in x1, x2, n1, and n2.
}
\examples{
# Binomial RD, MOVER-J method:
moverci(x1 = 5, n1 = 56, x2 = 0, n2 = 29)

# Binomial RD, Newcombe method:
moverci(x1 = 5, n1 = 56, x2 = 0, n2 = 29, type = "wilson")
}
\references{
Laud PJ. Equal-tailed confidence intervals for comparison of
rates. Pharmaceutical Statistics 2017; 16:334-348.

Newcombe RG. Interval estimation for the difference between independent
proportions: comparison of eleven methods. Statistics in Medicine 1998;
17(8):873-890.

Donner A, Zou G. Closed-form confidence intervals for functions of the
normal mean and standard deviation. Statistical Methods in Medical Research
2012; 21(4):347-359.

Fagerland MW, Newcombe RG. Confidence intervals for odds ratio and relative
risk based on the inverse hyperbolic sine transformation. Statistics in
Medicine 2013; 32(16):2823-2836.

Li HQ, Tang ML, Wong WK. Confidence intervals for ratio of two Poisson
rates using the method of variance estimates recovery. Computational
Statistics 2014; 29(3-4):869-889.
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
