% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-install.R
\name{pipeline_install}
\alias{pipeline_install}
\alias{pipeline_install_local}
\alias{pipeline_install_github}
\title{Install 'RAVE' pipelines}
\usage{
pipeline_install_local(
  src,
  to = c("default", "custom", "workdir", "tempdir"),
  upgrade = FALSE,
  force = FALSE,
  set_default = NA,
  ...
)

pipeline_install_github(
  repo,
  to = c("default", "custom", "workdir", "tempdir"),
  upgrade = FALSE,
  force = FALSE,
  set_default = NA,
  ...
)
}
\arguments{
\item{src}{pipeline directory}

\item{to}{installation path; choices are \code{'default'}, \code{'custom'},
\code{'workdir'}, and \code{'tempdir'}. Please specify pipeline root path
via \code{\link{pipeline_root}} when \code{'custom'} is used.}

\item{upgrade}{whether to upgrade the dependence; default is \code{FALSE}
for stability, however, it is highly recommended to upgrade your
dependencies}

\item{force}{whether to force installing the pipelines}

\item{set_default}{whether to set current pipeline module folder as the
default, will be automatically set when the pipeline is from the official
'Github' repository.}

\item{...}{other parameters not used}

\item{repo}{'Github' repository in user-repository combination, for example,
\code{'rave-ieeg/rave-pipeline'}}
}
\value{
nothing
}
\description{
Install 'RAVE' pipelines
}
\examples{

\dontrun{


pipeline_install_github("rave-ieeg/pipelines")


# or download github.com/rave-ieeg/pipelines repository, extract
# to a folder, and call
pipeline_install_local("path/to/pipeline/folder")

}


}
