% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odata-expectativas.R
\name{get_top5s_selic_market_expectations}
\alias{get_top5s_selic_market_expectations}
\title{Get Selic market expectations from top 5 providers}
\usage{
get_top5s_selic_market_expectations(start_date = NULL, end_date = NULL, ...)
}
\arguments{
\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the requested data.
}
\description{
Statistics of Selic expectations for top 5 indicators.
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
Check <https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/documentacao#ExpectativasMercadoTop5Selic>
for more details
}
\examples{
\dontrun{
# return all indicators for the specified date range
start_date <- "2022-01-01"
x <- get_top5s_selic_market_expectations(start_date = start_date, `$top` = 20)
}

}
