% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_coneshaped_model.R
\name{fit_coneshaped_model}
\alias{fit_coneshaped_model}
\title{Fit cone-shaped model}
\usage{
fit_coneshaped_model(sky_points, method = "zenith_n_azimuth")
}
\arguments{
\item{sky_points}{\code{data.frame} returned by \code{\link[=extract_rr]{extract_rr()}}. If it is generated
by other means, it must have columns \code{row}, \code{col}, \code{z}, \code{a}, and \code{rr}.}

\item{method}{character. Model type to fit:
\describe{
\item{\code{"zenith_only"}}{Quadratic polynomial in zenith angle.}
\item{\code{"zenith_n_azimuth"}}{Quadratic polynomial in zenith plus
sinusoidal terms in azimuth.}
}}
}
\value{
List with the following components:
\describe{
\item{\code{fun}}{Function taking \code{zenith} and \code{azimuth} (degrees) and returning
predicted relative radiance.}
\item{\code{model}}{\code{lm} object fitted by \code{\link[stats:lm]{stats::lm()}}.}
}
Returns \code{NULL} (with a warning) if the number of input points is fewer than 20.
}
\description{
Fit a polynomial model to predict relative radiance from
spherical coordinates using data sampled from a canopy photograph.
}
\details{
This model requires only \code{sky_points}, making it useful in workflows where
sun position cannot be reliably estimated, such as in \code{\link[=apply_by_direction]{apply_by_direction()}}.
Otherwise, \code{\link[=fit_cie_model]{fit_cie_model()}} is a better choice.

Depending on \code{method}, it can fit:
\describe{
\item{\emph{A zenith-only quadratic model}}{\deqn{sDN = a + b\theta + c\theta^2}}
\item{\emph{A zenith-plus-azimuth model, adding sinusoidal terms}}{\deqn{sDN = a + b\theta + c\theta^2 + d\sin(\phi) + e\cos(\phi)}}
}

See \insertCite{Diaz2018;textual}{rcaiman} for details on the full model.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
r <- caim$Blue

bin <- binarize_by_region(r, ring_segmentation(z, 15), "thr_isodata") &
  select_sky_region(z, 0, 88)

g <- sky_grid_segmentation(z, a, 10, first_ring_different = TRUE)
sky_points <- extract_sky_points(r, bin, g, dist_to_black = 3)
plot(bin)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
rr <- extract_rr(r, z, a, sky_points)

model <- fit_coneshaped_model(rr$sky_points)
summary(model$model)
sky_cs <- model$fun(z, a) * rr$zenith_dn
plot(sky_cs)

z_mini <- zenith_image(50, lens())
sky_cs <- model$fun(z_mini, azimuth_image(z_mini))
persp(sky_cs, theta = 90, phi = 20)

}
}
\references{
\insertAllCited{}
}
