% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_black.R
\name{grow_black}
\alias{grow_black}
\title{Grow black regions in a binary mask}
\usage{
grow_black(bin, dist_to_black)
}
\arguments{
\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binarized
hemispherical image. See \code{\link[=binarize_with_thr]{binarize_with_thr()}} for details.}

\item{dist_to_black}{numeric vector of length one. Buffer distance (pixels)
used to expand black regions.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} with the same dimensions as \code{bin}. Compared
to the input \code{bin}, black regions (\code{FALSE}) have been expanded by the
specified buffer distance.
}
\description{
Grow black pixels in a binary mask using a kernel of user-defined size.
Useful to reduce errors associated with inter-class borders.
}
\details{
Expands the regions with value \code{FALSE} (typically rendered as black) in a
binary image by applying a square-shaped buffer. Any white pixels (value
\code{TRUE}) within a distance equal to or less than \code{dist_to_black} from a black
pixel will be turned black.
}
\examples{
\dontrun{
r <- read_caim()
bin <- binarize_with_thr(r$Blue, thr_isodata(r$Blue[]))
plot(bin)
bin <- grow_black(bin, 11)
plot(bin)
}
}
