% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sector_segmentation.R
\name{sector_segmentation}
\alias{sector_segmentation}
\title{Assign azimuth-sector labels}
\usage{
sector_segmentation(a, angle_width)
}
\arguments{
\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{angle_width}{numeric vector of lenght one. Sector width in degrees.
Must divide the 0–360 deg range into an integer number of sectors.}
}
\value{
Single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} with integer values.
Segments will resemble pizza slices.
}
\description{
Segment a hemispherical view into equal azimuth sectors by slicing the
azimuth angle from \code{0} to \code{360} deg at fixed steps.
}
\examples{
z <- zenith_image(600, lens())
a <- azimuth_image(z)
sectors <- sector_segmentation(a, 15)
plot(sectors == 1)
}
