% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_to_buildignore.R
\name{add_to_buildignore}
\alias{add_to_buildignore}
\title{Add to the .Rbuildignore file}
\usage{
add_to_buildignore(x, open = FALSE, quiet = FALSE)
}
\arguments{
\item{x}{A character vector. One or several files/folders names to be added
to the \code{.Rbuildignore}. This argument is mandatory.}

\item{open}{A logical value. If \code{TRUE} the \code{.Rbuildignore} file is opened in
the editor. Default is \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function adds files/folders to the \code{.Rbuildignore} file. If a
\code{.Rbuildignore} is already present, files to be ignored while checking
package are just added to this file. Otherwise a new file is created.
}
\examples{
\dontrun{
add_to_buildignore(open = TRUE)
add_to_buildignore(".DS_Store")
}
}
\seealso{
Other development functions: 
\code{\link{add_dependencies}()},
\code{\link{add_github_actions_check}()},
\code{\link{add_github_actions_citation}()},
\code{\link{add_github_actions_codecov}()},
\code{\link{add_github_actions_codemeta}()},
\code{\link{add_github_actions_document}()},
\code{\link{add_github_actions_pkgdown}()},
\code{\link{add_github_actions_render}()},
\code{\link{add_r_depend}()},
\code{\link{add_to_gitignore}()}
}
\concept{development functions}
