% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chainsaw.R
\name{chainsaw}
\alias{chainsaw}
\title{Function to cut the phylogeny to a specified depth from the tip with the
greatest distance from the root.}
\usage{
chainsaw(partition, ps, depth)
}
\arguments{
\item{partition}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types (species), columns as subcommunities, and each
element containing the relative abundance of types in each subcommunity
relative to the metacommunity as a whole. In the phylogenetic case, this
corresponds to the proportional abundance of historical species, which is
calculated from the proportional abundance of terminal taxa}

\item{ps}{\code{phy_struct()} output}

\item{depth}{proportion of total tree height to be conserved (taken as
a proportion from the highest tip). Describes how far back we go in the tree,
with 0 marking the date of the most recent tip, and 1 marking the most
recent common ancestor. Numbers greater than 1 extend the root of the tree}
}
\value{
\code{chainsaw()} returns an object of class \code{metacommunity}
}
\description{
Function to cut the phylogeny to a specified depth from the tip with the
greatest distance from the root.
}
