% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{hoverlight}
\alias{hoverlight}
\title{Theme hoverlight}
\usage{
hoverlight(
  font_size = 15,
  font_color = "#ffffff",
  header_font_size = 15,
  cell_padding = 4,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table.
Default is #ffffff.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 4.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Changes from dark-themed to light-themed on hover
}
\examples{
data <- iris[10:29, ]

## Standard hoverlight theme
reactable(data,
          theme = hoverlight())

## Additional options applied
reactable(data,
          theme = hoverlight(font_size = 12, font_color = "grey", cell_padding = 3))

}
