% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed_of_sound.R
\name{speed_of_sound}
\alias{speed_of_sound}
\title{Compute speed of sound in water given salinity, temperature, and depth}
\usage{
speed_of_sound(sal, temp, depth)
}
\arguments{
\item{sal}{Salinity (PSU)}

\item{temp}{Water temperature (degrees C)}

\item{depth}{Water depth (m) or pressure (dBar)}
}
\value{
Speed of sound in water (m/s)
}
\description{
Computes speed of sound in water per Del grosso (1974)
}
\examples{
InputData <- realTimeloads::ExampleData
Sonde<- InputData$Sonde
sal <- ctd2sal(Sonde$Conductivity_uS_per_cm,Sonde$Water_Temperature_degC,Sonde$Pressure_dbar)
c <- speed_of_sound(sal,Sonde$Water_Temperature_degC,Sonde$Pressure_dbar)
}
\references{
Del Grosso, V. A. (1974). New equation for the speed of sound in natural waters (with comparisons to other equations). The Journal of the Acoustical Society of America, 56(4), 1084-1091.
Author modified matlab code from David Schoellhamer
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
