% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_digit.R
\name{final_digit_fn}
\alias{final_digit_fn}
\title{Compares proportions of final digits from summary statistics}
\usage{
final_digit_fn(
  df = generic_data,
  vars = "",
  dec.pl = "no",
  dec.pl.vars = "",
  title = "",
  verbose = TRUE
)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{vars}{vector of the summary statistics to be used}

\item{dec.pl}{"yes" or "no" indicator whether columns for decimal places are included (yes) or should be calculated (no)}

\item{dec.pl.vars}{vector of the names of the columns for decimal places for each statistics}

\item{title}{title name for plots (optional)}

\item{verbose}{TRUE or FALSE indicates whether print plot}
}
\value{
list containing 5 objects as described

\itemize{
\item digit_graph = plot of proportions of final digits
\item digit_ft = flextable of results
\item digit_table = data frame of results
\item digit_dataset = data frame of data set used to generate results data
\item digit_data = results of analyses used to generate results data
}
}
\description{
Creates graph of proportion of final digits for summary statistics of specified variables\cr
}
\details{
This approach is still in development and needs validation and discussion about its place in integrity assessment.\cr

Requires data frame containing columns for study, variable (named var), summary statistic(s) (named with single letter eg m or s),
and optional columns for decimal places for each statistic (named dp_* eg dp_m, dp_s). Data can be imported using the generic option of load_clean function\cr

Returns a list containing 5 objects and prints the plot digit_graph
}
\examples{
# load example data
generic_data <- load_clean(import= "no", file.cont = "SI_pvals_cont", generic= "yes",
gen.vars.del = c("p"), format.cont = "wide")$generic_data

\donttest{
# run function (takes only a few seconds)
final_digit_fn(vars = c("m","s"), dec.pl = "n")$digit_graph

# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
generic_data <- load_clean(import= "yes", generic = "yes", dir = path,
    file.name.cont = "reappraised_examples.xlsx", sheet.name.cont = "SI_pvals_cont",
    range.name.cont = "A1:O51", gen.vars.del = c("p"),
    format.cont = "wide")$generic_data}
}
