% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/receptiviti_norming.R
\name{receptiviti_norming}
\alias{receptiviti_norming}
\title{View or Establish Custom Norming Contexts}
\usage{
receptiviti_norming(name = NULL, text = NULL, options = list(),
  delete = FALSE, name_only = FALSE, id = NULL, text_column = NULL,
  id_column = NULL, files = NULL, dir = NULL, file_type = "txt",
  collapse_lines = FALSE, encoding = NULL, bundle_size = 1000,
  bundle_byte_limit = 7500000, retry_limit = 50,
  clear_scratch_cache = TRUE, use_future = FALSE, in_memory = TRUE,
  url = Sys.getenv("RECEPTIVITI_URL"), key = Sys.getenv("RECEPTIVITI_KEY"),
  secret = Sys.getenv("RECEPTIVITI_SECRET"), verbose = TRUE)
}
\arguments{
\item{name}{Name of a new norming context, to be established from the provided \code{text}.
Not providing a name will list the previously created contexts.}

\item{text}{Text to be processed and used as the custom norming context.
Not providing text will return the status of the named norming context.}

\item{options}{Options to set for the norming context (e.g.,
\code{list(min_word_count = 350,} \code{max_punctuation = .25)}).}

\item{delete}{Logical; If \code{TRUE}, will request to remove the \code{name} context.}

\item{name_only}{Logical; If \code{TRUE}, will return a character vector of names
only, including those of build-in contexts.}

\item{id, text_column, id_column, files, dir, file_type, collapse_lines, encoding}{Additional
arguments used to handle \code{text}; same as those in \code{\link{receptiviti}}.}

\item{bundle_size, bundle_byte_limit, retry_limit, clear_scratch_cache, use_future, in_memory}{Additional arguments used to manage the requests; same as those in
\code{\link{receptiviti}}.}

\item{key, secret, url}{Request arguments; same as those in \code{\link{receptiviti}}.}

\item{verbose}{Logical; if \code{TRUE}, will show status messages.}
}
\value{
Nothing if \code{delete} if \code{TRUE}.
Otherwise, if \code{name} is not specified, a character vector containing names of each
available norming context (built-in and custom).
If \code{text} is not specified, the status of the
named context in a \code{list}. If \code{text}s are provided, a \code{list}:
\itemize{
   \item \code{initial_status}: Initial status of the context.
   \item \code{first_pass}: Response after texts are sent the first time, or
     \code{NULL} if the initial status is \code{pass_two}.
   \item \code{second_pass}: Response after texts are sent the second time.
}
}
\description{
Custom norming contexts can be used to process later texts by specifying the
\code{custom_context} API argument in the \code{receptiviti} function (e.g.,
\code{receptiviti("text to score", version = "v2",
options = list(custom_context = "norm_name"))},
where \code{norm_name} is the name you set here).
}
\examples{
\dontrun{

# get status of all existing custom norming contexts
contexts <- receptiviti_norming(name_only = TRUE)

# create or get the status of a single custom norming context
status <- receptiviti_norming("new_context")

# send texts to establish the context

## these texts can be specified just like
## texts in the main receptiviti function

## such as directly
full_status <- receptiviti_norming("new_context", c(
  "a text to set the norm",
  "another text part of the new context"
))

## or from a file
full_status <- receptiviti_norming(
  "new_context", "./path/to/text.csv",
  text_column = "texts"
)

## or from multiple files in a directory
full_status <- receptiviti_norming(
  "new_context",
  dir = "./path/to/txt_files"
)
}
}
