% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{ocv_crop_annotorious}
\alias{ocv_crop_annotorious}
\title{Crop annotations to a bounding box}
\usage{
ocv_crop_annotorious(data, bbox)
}
\arguments{
\item{data}{an object as returned by \code{\link{read_annotorious}}}

\item{bbox}{a vector with elements x, y, xmax, ymax}
}
\value{
\code{data} where column \code{polygon} and the rectangle information in \code{x, y, width, height} is limited to the provided bounding box
}
\description{
Crop annotations to a bounding box
}
\examples{
\dontshow{
if(require(opencv))
\{
}
library(opencv)
data(openseadragon_areas)
\dontshow{
  url <- system.file(package = "recogito", "examples",
                     "Cat_and_dog_standoff_(3926784260).jpg")
  attr(openseadragon_areas, "src") <- url
}
url  <- attr(openseadragon_areas, "src")
img  <- ocv_read(url)
bbox <- ocv_info(img)
bbox <- c(xmin = 0, ymin = 0, xmax = bbox$width - 1, ymax = bbox$height - 1)
x    <- ocv_crop_annotorious(data = openseadragon_areas)
x    <- ocv_crop_annotorious(data = openseadragon_areas, bbox = bbox)

img
area <- x[2, ]
ocv_polygon(img, pts = area$polygon[[1]], crop = TRUE)
area <- x[1, ]
ocv_rectangle(img, x = area$x, y = area$y, width = area$width, height = area$height)
area <- x[3, ]
ocv_rectangle(img, x = area$x, y = area$y, width = area$width, height = area$height)
\dontshow{
\}
}
}
